/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome.request;

import com.synopsys.integration.phonehome.UniquePhoneHomeProduct;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBodyBuilder;
import com.synopsys.integration.util.NameVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PhoneHomeRequestBody {
    public static final int MAX_META_DATA_CHARACTERS = 1536;
    public static final String UNKNOWN_FIELD_VALUE = "<unknown>";
    public static final PhoneHomeRequestBody DO_NOT_PHONE_HOME = null;
    private final String customerId;
    private final String hostName;
    private final NameVersion artifactInfo;
    private final UniquePhoneHomeProduct product;
    private final String productVersion;
    private final List<String> artifactModules;
    private final Map<String, String> metaData;

    public PhoneHomeRequestBody(String customerId, String hostName, NameVersion artifactInfo, UniquePhoneHomeProduct product, String productVersion, List<String> artifactModules, Map<String, String> metaData) {
        this.customerId = customerId;
        this.hostName = hostName;
        this.artifactInfo = artifactInfo;
        this.product = product;
        this.productVersion = productVersion;
        this.artifactModules = Collections.unmodifiableList(artifactModules);
        this.metaData = Collections.unmodifiableMap(metaData);
    }

    PhoneHomeRequestBody(PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder) {
        this.customerId = phoneHomeRequestBodyBuilder.getCustomerId();
        this.hostName = phoneHomeRequestBodyBuilder.getHostName();
        this.artifactInfo = phoneHomeRequestBodyBuilder.getArtifactInfo();
        this.product = phoneHomeRequestBodyBuilder.getProduct();
        this.productVersion = phoneHomeRequestBodyBuilder.getProductVersion();
        this.artifactModules = Collections.unmodifiableList(phoneHomeRequestBodyBuilder.getArtifactModules());
        this.metaData = Collections.unmodifiableMap(phoneHomeRequestBodyBuilder.getMetaData());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getArtifactId() {
        return this.artifactInfo.getName();
    }

    public String getArtifactVersion() {
        return this.artifactInfo.getVersion();
    }

    public String getProductName() {
        return this.product.getName();
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public List<String> getArtifactModules() {
        return this.artifactModules;
    }
}

