/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome;

import com.google.gson.Gson;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.exception.PhoneHomeException;
import com.synopsys.integration.phonehome.google.analytics.GoogleAnalyticsRequestHelper;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBody;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class PhoneHomeClient {
    public static final String BLACKDUCK_SKIP_PHONE_HOME_VARIABLE = "BLACKDUCK_SKIP_PHONE_HOME";
    public static final String BLACKDUCK_PHONE_HOME_URL_OVERRIDE_VARIABLE = "BLACKDUCK_PHONE_HOME_URL_OVERRIDE";
    public static final String SKIP_PHONE_HOME_VARIABLE = "SYNOPSYS_SKIP_PHONE_HOME";
    public static final String PHONE_HOME_URL_OVERRIDE_VARIABLE = "SYNOPSYS_PHONE_HOME_URL_OVERRIDE";
    private final HttpClientBuilder httpClientBuilder;
    private final IntLogger logger;
    private final Gson gson;

    public PhoneHomeClient(IntLogger logger, HttpClientBuilder httpClientBuilder, Gson gson) {
        this.httpClientBuilder = httpClientBuilder;
        this.logger = logger;
        this.gson = gson;
    }

    public void postPhoneHomeRequest(PhoneHomeRequestBody phoneHomeRequestBody, Map<String, String> environmentVariables) throws PhoneHomeException {
        if (this.skipPhoneHome(environmentVariables)) {
            this.logger.debug("Skipping phone home");
            return;
        }
        if (phoneHomeRequestBody == null) {
            throw new PhoneHomeException("The request body must not be null.");
        }
        String overrideUrl = this.checkOverridePhoneHomeUrl(environmentVariables);
        try (CloseableHttpClient client = this.httpClientBuilder.build();){
            HttpPost request;
            GoogleAnalyticsRequestHelper requestHelper = new GoogleAnalyticsRequestHelper(this.gson);
            if (overrideUrl != null) {
                this.logger.debug("Overriding Phone-Home URL: " + overrideUrl);
                request = requestHelper.createRequest(phoneHomeRequestBody, overrideUrl);
            } else {
                request = requestHelper.createRequest(phoneHomeRequestBody);
            }
            this.logger.debug("Phoning home to " + request.getURI());
            CloseableHttpResponse response = client.execute(request);
            this.logger.trace("Response Code: " + response.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            throw new PhoneHomeException(e.getMessage(), e);
        }
    }

    private boolean skipPhoneHome(Map<String, String> environmentVariables) {
        if (environmentVariables.containsKey(SKIP_PHONE_HOME_VARIABLE) || environmentVariables.containsKey(BLACKDUCK_SKIP_PHONE_HOME_VARIABLE)) {
            String valueString = environmentVariables.get(SKIP_PHONE_HOME_VARIABLE);
            if (StringUtils.isBlank((CharSequence)valueString)) {
                valueString = environmentVariables.get(BLACKDUCK_SKIP_PHONE_HOME_VARIABLE);
            }
            return BooleanUtils.toBoolean((String)valueString);
        }
        return false;
    }

    private String checkOverridePhoneHomeUrl(Map<String, String> environmentVariables) {
        String overrideUrl = environmentVariables.get(PHONE_HOME_URL_OVERRIDE_VARIABLE);
        if (StringUtils.isBlank((CharSequence)overrideUrl)) {
            overrideUrl = environmentVariables.get(BLACKDUCK_PHONE_HOME_URL_OVERRIDE_VARIABLE);
        }
        return overrideUrl;
    }
}

