/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class Rules {
    Rules() {
    }

    public static String checkToken(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null token");
        Preconditions.checkArgument(RFC7230.isToken(input), "invalid token: %s", (Object)input);
        return input.toString();
    }

    public static String checkComment(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null comment");
        Preconditions.checkArgument(RFC7230.isComment(input), "invalid comment: %s", (Object)input);
        return input.toString();
    }

    public static String checkQuotedString(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null comment");
        Preconditions.checkArgument(RFC7230.isQuotedString(input), "invalid quoted-string: %s", (Object)input);
        return input.toString();
    }

    public static String checkRelationTypes(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null relation-types");
        Preconditions.checkArgument(RFC5988.isRelationTypes(input), "invalid relation-types: %s", (Object)input);
        return input.toString();
    }

    public static String checkURIReference(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null URI-Reference");
        Preconditions.checkArgument(Rules.matchesWithQuotes(input, '\"', '\"', RFC3986::isURIReference));
        return input.toString();
    }

    public static String checkScheme(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null scheme");
        Preconditions.checkArgument(RFC3986.isScheme(input), "invalid scheme: %s", (Object)input);
        return Ascii.toLowerCase(input);
    }

    public static String checkLanguageTag(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null Language-Tag");
        Preconditions.checkArgument(RFC5646.isLanguageTag(input), "invalid Language-Tag: %s", (Object)input);
        return input.toString();
    }

    public static String checkExtValue(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null ext-value");
        Preconditions.checkArgument(RFC5987.isExtValue(input), "invalid ext-value: %s", (Object)input);
        return input.toString();
    }

    public static String checkMediaDesc(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null MediaDesc");
        Preconditions.checkArgument(REChtml401.isMediaDesc(input) || Rules.matchesWithQuotes(input, '\"', '\"', REChtml401::isMediaDesc), "invalid MediaDesc: %s", (Object)input);
        return input.toString();
    }

    public static String checkMediaTypeOrQuotedMt(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null media-type");
        Preconditions.checkArgument(RFC5988.isMediaType(input) || Rules.matchesWithQuotes(input, '\"', '\"', RFC5988::isMediaType), "invalid media-type or quoted-mt: %s", (Object)input);
        return input.toString();
    }

    public static void checkLinkExtension(@Nullable CharSequence parmname, @Nullable CharSequence value) {
        Preconditions.checkArgument(parmname != null, "null parmname");
        Preconditions.checkArgument(value != null, "null value");
        Preconditions.checkArgument(RFC5988.isLinkExtension(parmname, value), "invalid link-extension: %s=%s", (Object)parmname, (Object)value);
    }

    public static String checkAttribute(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null attribute");
        Preconditions.checkArgument(RFC2045.isToken(input), "invalid attribute: %s", (Object)input);
        return Ascii.toLowerCase(input);
    }

    public static String checkValue(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null value");
        Preconditions.checkArgument(RFC2045.isToken(input) || RFC7230.isQuotedString(input), "invalid value: %s", (Object)input);
        return input.toString();
    }

    public static String checkType(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null type");
        Preconditions.checkArgument(RFC4288.isTypeName(input), "invalid type: %s", (Object)input);
        return Ascii.toLowerCase(input);
    }

    public static String checkSubtype(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null subtype");
        Preconditions.checkArgument(RFC4288.isSubtypeName(input), "invalid subtype: %s", (Object)input);
        return Ascii.toLowerCase(input);
    }

    public static boolean isBytesUnit(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null unit");
        return RFC7233.isBytesUnit(input);
    }

    public static String checkOtherRangeUnit(@Nullable CharSequence input) {
        Preconditions.checkArgument(input != null, "null unit");
        Preconditions.checkArgument(RFC7233.isOtherRangeUnit(input), "invalid unit: %s", (Object)input);
        return input.toString();
    }

    public static boolean matchesWithQuotes(CharSequence input, char quoteStart, char quoteEnd, Predicate<CharSequence> predicate) {
        int limit = input.length() - 1;
        return input.length() > 2 && input.charAt(0) == quoteStart && input.charAt(limit) == quoteEnd && predicate.test(input.subSequence(1, limit));
    }

    public static int next(CharSequence input, CharMatcher matcher, int start) {
        int pos;
        int length = input.length();
        for (pos = start; pos < length && matcher.matches(input.charAt(pos)); ++pos) {
        }
        return pos;
    }

    public static int nextToken(TokenType tokenType, CharSequence input, int start) {
        return Rules.next(input, tokenType.keyTokenChar, start);
    }

    public static int nextRegName(CharSequence input, int start) {
        if (input.length() > start + 127) {
            return Rules.next(input.subSequence(start, start + 127), RFC4288.regNameChars, start);
        }
        return Rules.next(input, RFC4288.regNameChars, start);
    }

    public static int nextDigit(CharSequence input, int start) {
        return Rules.next(input, RFC5234.DIGIT, start);
    }

    public static int nextNonWsp(CharSequence input, int start) {
        return Rules.next(input, RFC5234.WSP, start);
    }

    public static int nextChar(CharSequence input, int start, char expected) {
        Preconditions.checkArgument(start < input.length(), "missing %s: %s", expected, (Object)input);
        return input.charAt(start) == expected ? start + 1 : start;
    }

    public static int nextTokenOrQuotedString(TokenType tokenType, CharSequence input, int start) {
        if (tokenType.valueTokenChar.matches(input.charAt(start))) {
            return Rules.nextToken(tokenType, input, start);
        }
        if (input.charAt(start) == '\"') {
            int pos = start + 1;
            int length = input.length();
            while (pos < length) {
                char c;
                if ((c = input.charAt(pos++)) == '\"') {
                    return pos;
                }
                if (c != '\\' || pos >= length) continue;
                ++pos;
            }
            throw new IllegalArgumentException("missing DQUOTE: " + input);
        }
        return start;
    }

    public static int remainingNameValues(TokenType tokenType, CharSequence input, int start, BiConsumer<CharSequence, CharSequence> consumer) {
        int pos = start;
        int length = input.length();
        int end = pos;
        while (end < length) {
            pos = Rules.nextNonWsp(input, end);
            Preconditions.checkArgument(pos < length && input.charAt(pos) == ';', "missing pair delimiter (;): %s", (Object)input);
            pos = end = Rules.nextNonWsp(input, pos + 1);
            end = Rules.nextToken(tokenType, input, pos);
            Preconditions.checkArgument(end > pos, "missing pair name: %s", (Object)input);
            CharSequence name = input.subSequence(pos, end);
            pos = Rules.nextNonWsp(input, end);
            Preconditions.checkArgument(pos < input.length() && input.charAt(pos) == '=', "missing pair splitter (=): %s", (Object)input);
            pos = end = Rules.nextNonWsp(input, pos + 1);
            end = Rules.nextTokenOrQuotedString(tokenType, input, pos);
            Preconditions.checkArgument(end > pos, "missing pair value: %s", (Object)input);
            consumer.accept(name, input.subSequence(pos, end));
        }
        return end;
    }

    public static int remainingTokens(CharSequence input, int start, Consumer<CharSequence> consumer) {
        int pos = start;
        int length = input.length();
        StringBuilder buffer = new StringBuilder();
        int commentDepth = 0;
        while (pos < length) {
            char c;
            if ((c = input.charAt(pos++)) == '\\' && pos < length) {
                buffer.append(input.charAt(++pos));
                continue;
            }
            if (c == '(') {
                ++commentDepth;
                buffer.append(c);
                continue;
            }
            if (c == ')') {
                buffer.append(c);
                Preconditions.checkArgument(--commentDepth >= 0, "unbalanced '(...)': %s", (Object)input);
                if (commentDepth != 0) continue;
                consumer.accept(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (RFC5234.WSP.matches(c) && commentDepth == 0) {
                if (buffer.length() <= 0) continue;
                consumer.accept(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            consumer.accept(buffer.toString());
        }
        return pos;
    }

    @Nullable
    public static String retainTokenChars(TokenType tokenType, @Nullable CharSequence input) {
        if (input != null) {
            String result = tokenType.keyTokenChar.retainFrom(input);
            Preconditions.checkArgument(input.length() == 0 || !result.isEmpty(), "input contained no token characters: " + input);
            return result;
        }
        return null;
    }

    public static enum TokenType {
        RFC2045(com.blackducksoftware.common.value.Rules$RFC2045.access$1100(), com.blackducksoftware.common.value.Rules$RFC2045.access$1100()),
        RFC5988(RFC5987.access$1200(), com.blackducksoftware.common.value.Rules$RFC5988.access$1300()),
        RFC7230(com.blackducksoftware.common.value.Rules$RFC7230.access$1400(), com.blackducksoftware.common.value.Rules$RFC7230.access$1400());

        private final CharMatcher keyTokenChar;
        private final CharMatcher valueTokenChar;

        private TokenType(CharMatcher keyTokenChar, CharMatcher valueTokenChar) {
            this.keyTokenChar = Objects.requireNonNull(keyTokenChar);
            this.valueTokenChar = Objects.requireNonNull(valueTokenChar);
        }
    }

    static final class REChtml401 {
        REChtml401() {
        }

        public static final boolean isMediaDesc(CharSequence input) {
            return true;
        }
    }

    @VisibleForTesting
    static final class RFC7233 {
        private static final String bytesUnit = "bytes";

        RFC7233() {
        }

        public static final boolean isBytesUnit(CharSequence input) {
            return bytesUnit.contentEquals(input);
        }

        public static final boolean isOtherRangeUnit(CharSequence input) {
            return RFC7230.isToken(input);
        }
    }

    @VisibleForTesting
    static final class RFC7230 {
        private static final CharMatcher tchar = CharMatcher.anyOf("!#$%&'*+-.^_`|~").or(RFC5234.access$300()).or(RFC5234.access$400());
        private static final CharMatcher obsText = CharMatcher.inRange('\u0080', '\u00ff');
        private static final CharMatcher qdtext = RFC5234.access$800().or(RFC5234.access$700()).or(CharMatcher.is('!')).or(CharMatcher.inRange('#', '[')).or(CharMatcher.inRange(']', '~')).or(obsText);
        private static final CharMatcher ctext = RFC5234.access$800().or(RFC5234.access$700()).or(CharMatcher.inRange('!', '\'')).or(CharMatcher.inRange('*', '[')).or(CharMatcher.inRange(']', '~')).or(obsText);

        RFC7230() {
        }

        public static boolean isCtext(char c) {
            return ctext.matches(c);
        }

        public static boolean isToken(CharSequence input) {
            return input.length() > 0 && tchar.matchesAllOf(input);
        }

        public static boolean isQuotedPair(CharSequence input) {
            return input.length() == 2 && input.charAt(0) == '\\' && RFC5234.HTAB.or(RFC5234.SP).or(RFC5234.VCHAR).or(obsText).matches(input.charAt(1));
        }

        public static boolean isQuotedString(CharSequence input) {
            int limit = input.length() - 1;
            if (input.length() >= 2 && RFC5234.DQUOTE.matches(input.charAt(0)) && RFC5234.DQUOTE.matches(input.charAt(limit))) {
                int pos = 1;
                while (pos < limit) {
                    if (qdtext.matches(input.charAt(pos))) {
                        ++pos;
                        continue;
                    }
                    if (RFC7230.isQuotedPair(input.subSequence(pos, Math.min(pos + 2, limit)))) {
                        pos += 2;
                        continue;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public static boolean isComment(CharSequence input) {
            int limit = input.length() - 1;
            if (input.length() >= 2 && input.charAt(0) == '(' && input.charAt(limit) == ')') {
                int pos = 1;
                while (pos < limit) {
                    if (ctext.matches(input.charAt(pos))) {
                        ++pos;
                        continue;
                    }
                    if (RFC7230.isQuotedPair(input.subSequence(pos, Math.min(pos + 2, limit)))) {
                        pos += 2;
                        continue;
                    }
                    int end = RFC7230.nextComment(input, pos, limit);
                    if (RFC7230.isComment(input.subSequence(pos, end))) {
                        pos = end;
                        continue;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private static int nextComment(CharSequence input, int start, int limit) {
            for (int end = start; end < limit; ++end) {
                if (input.charAt(end) == '\\') {
                    ++end;
                    continue;
                }
                if (input.charAt(end) != ')') continue;
                return end + 1;
            }
            return limit;
        }

        static /* synthetic */ CharMatcher access$1400() {
            return tchar;
        }
    }

    @VisibleForTesting
    static final class RFC5988 {
        private static final CharMatcher ptokenchar = RFC5234.access$400().or(RFC5234.access$300()).or(CharMatcher.anyOf("!#$%&'()*+-./:<=>?@[]^_`{|}~"));

        RFC5988() {
        }

        public static boolean isExtNameStar(CharSequence input) {
            return input.length() > 1 && input.charAt(input.length() - 1) == '*' && RFC5987.isParmname(input.subSequence(0, input.length() - 1));
        }

        public static boolean isPtoken(CharSequence input) {
            return input.length() > 0 && ptokenchar.matchesAllOf(input);
        }

        public static boolean isRegRelType(CharSequence input) {
            return input.length() > 0 && RFC2616.LOALPHA.matches(input.charAt(0)) && RFC2616.LOALPHA.or(RFC5234.DIGIT).or(CharMatcher.is('.')).or(CharMatcher.is('-')).matchesAllOf(input);
        }

        public static boolean isRelationType(CharSequence input) {
            return RFC5988.isRegRelType(input) || RFC3986.isURI(input);
        }

        public static boolean isRelationTypes(CharSequence input) {
            return RFC5988.isRelationType(input) || Rules.matchesWithQuotes(input, '\"', '\"', i -> Splitter.on(RFC5234.SP).omitEmptyStrings().splitToList((CharSequence)i).stream().allMatch(RFC5988::isRelationType));
        }

        public static boolean isMediaType(CharSequence input) {
            List<String> mediaType = Splitter.on('/').limit(2).splitToList(input);
            return mediaType.size() == 2 && RFC4288.isTypeName(mediaType.get(0)) && RFC4288.isSubtypeName(mediaType.get(1));
        }

        public static boolean isLinkExtension(CharSequence parmname, CharSequence value) {
            if (RFC5987.isParmname(parmname)) {
                return RFC5988.isPtoken(value) || RFC7230.isQuotedString(value);
            }
            if (RFC5988.isExtNameStar(parmname)) {
                return RFC5987.isExtValue(value);
            }
            return false;
        }

        static /* synthetic */ CharMatcher access$1300() {
            return ptokenchar;
        }
    }

    @VisibleForTesting
    static final class RFC5987 {
        private static final CharMatcher attrChar = RFC5234.access$400().or(RFC5234.access$300()).or(CharMatcher.anyOf("!#$&+-.^_`|~"));
        private static final CharMatcher mimeCharsetc = RFC5234.access$400().or(RFC5234.access$300()).or(CharMatcher.anyOf("!#$%&+-^_`{}~"));

        RFC5987() {
        }

        public static boolean isValueChars(CharSequence input) {
            int length = input.length();
            for (int index = 0; index < length; ++index) {
                if (!(input.charAt(index) == '%' ? index + 2 > length || !RFC5234.HEXDIG.matches(input.charAt(index + 1)) || !RFC5234.HEXDIG.matches(input.charAt(index + 2)) : !attrChar.matches(input.charAt(index)))) continue;
                return false;
            }
            return true;
        }

        public static boolean isCharset(CharSequence input) {
            return "UTF-8".contentEquals(input) || "ISO-8859-1".contentEquals(input) || input.length() > 0 && mimeCharsetc.matchesAllOf(input);
        }

        public static boolean isParmname(CharSequence input) {
            return input.length() > 0 && attrChar.matchesAllOf(input);
        }

        public static boolean isExtValue(CharSequence input) {
            List<String> extValue = Splitter.on('\'').limit(3).splitToList(input);
            return extValue.size() == 3 && RFC5987.isCharset(extValue.get(0)) && (extValue.get(1).isEmpty() || RFC5646.isLanguageTag(extValue.get(1))) && RFC5987.isValueChars(extValue.get(2));
        }

        static /* synthetic */ CharMatcher access$1200() {
            return attrChar;
        }
    }

    @VisibleForTesting
    static final class RFC5646 {
        RFC5646() {
        }

        public static boolean isLanguageTag(CharSequence input) {
            try {
                new Locale.Builder().setLanguageTag(input.toString());
                return true;
            }
            catch (IllformedLocaleException e) {
                return false;
            }
        }
    }

    static final class RFC5234 {
        private static final CharMatcher ALPHA = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z'));
        private static final CharMatcher DIGIT = CharMatcher.inRange('0', '9');
        private static final CharMatcher DQUOTE = CharMatcher.is('\"');
        private static final CharMatcher HEXDIG = DIGIT.or(CharMatcher.inRange('A', 'F'));
        private static final CharMatcher HTAB = CharMatcher.is('\t');
        private static final CharMatcher SP = CharMatcher.is(' ');
        private static final CharMatcher VCHAR = CharMatcher.inRange('!', '~');
        private static final CharMatcher WSP = SP.or(HTAB);

        RFC5234() {
        }
    }

    @VisibleForTesting
    static final class RFC4288 {
        private static final CharMatcher regNameChars = RFC5234.access$400().or(RFC5234.access$300()).or(CharMatcher.anyOf("!#$&.+-^_"));

        RFC4288() {
        }

        public static boolean isRegName(CharSequence input) {
            return input.length() > 0 && input.length() < 128 && regNameChars.matchesAllOf(input);
        }

        public static boolean isTypeName(CharSequence input) {
            return RFC4288.isRegName(input);
        }

        public static boolean isSubtypeName(CharSequence input) {
            return RFC4288.isRegName(input);
        }
    }

    @VisibleForTesting
    static final class RFC3986 {
        RFC3986() {
        }

        public static boolean isURI(CharSequence input) {
            try {
                return new URI(input.toString()).isAbsolute();
            }
            catch (URISyntaxException e) {
                return false;
            }
        }

        public static boolean isURIReference(CharSequence input) {
            try {
                new URI(input.toString());
                return true;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }

        public static boolean isScheme(CharSequence input) {
            return RFC5234.ALPHA.or(RFC5234.DIGIT).or(CharMatcher.anyOf("+-.")).matchesAllOf(input) && input.length() > 0 && RFC5234.ALPHA.matches(input.charAt(0));
        }
    }

    @VisibleForTesting
    static final class RFC2616 {
        private static final CharMatcher LOALPHA = CharMatcher.inRange('a', 'z');

        RFC2616() {
        }
    }

    @VisibleForTesting
    static final class RFC2045 {
        private static final CharMatcher tspecials = CharMatcher.anyOf("()<>@,;:\\\"/[]?=");
        private static final CharMatcher TOKEN_CHAR_MATCHER = RFC822.access$200().and(RFC822.access$100().or(RFC822.access$000()).or(tspecials).negate());

        RFC2045() {
        }

        public static boolean isToken(CharSequence input) {
            return input.length() > 0 && TOKEN_CHAR_MATCHER.matchesAllOf(input);
        }

        static /* synthetic */ CharMatcher access$1100() {
            return TOKEN_CHAR_MATCHER;
        }
    }

    @VisibleForTesting
    static final class RFC822 {
        private static final CharMatcher CHAR = CharMatcher.inRange('\u0000', '\u007f');
        private static final CharMatcher SPACE = CharMatcher.is(' ');
        private static final CharMatcher CTL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.is('\u007f'));

        RFC822() {
        }

        static /* synthetic */ CharMatcher access$000() {
            return CTL;
        }

        static /* synthetic */ CharMatcher access$100() {
            return SPACE;
        }

        static /* synthetic */ CharMatcher access$200() {
            return CHAR;
        }
    }
}

