/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraFunctions;
import com.blackducksoftware.common.value.Rules;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class Product {
    private final String name;
    private final Optional<String> version;
    private final ImmutableList<String> comments;

    public static Product os() {
        return new Builder().name(Rules.retainTokenChars(Rules.TokenType.RFC7230, StandardSystemProperty.OS_NAME.value())).version(StandardSystemProperty.OS_VERSION.value()).addCommentText("%s", StandardSystemProperty.OS_ARCH.value()).build();
    }

    public static Product java() {
        return new Builder().name("Java").version(StandardSystemProperty.JAVA_VERSION.value()).addCommentText("%s", StandardSystemProperty.JAVA_VENDOR.value()).build();
    }

    private Product(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.version = Optional.ofNullable(builder.version);
        this.comments = ImmutableList.copyOf(builder.comments);
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String version() {
        return this.version.orElse(null);
    }

    public List<String> comments() {
        return this.comments;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Product) {
            Product other = (Product)obj;
            return this.name.equals(other.name) && this.version.equals(other.version);
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.name);
        if (this.version.isPresent()) {
            result.append('/').append(this.version.get());
        }
        for (String comment : this.comments) {
            result.append(' ').append(comment);
        }
        return result.toString();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Product valueOf(String input) {
        return Product.parse(input);
    }

    public static Product parse(CharSequence input) {
        Builder builder = new Builder();
        builder.parse(input);
        return builder.build();
    }

    public static class Builder {
        private String name;
        private String version;
        private List<String> comments;

        public Builder() {
            this.comments = new ArrayList<String>(1);
        }

        private Builder(Product product) {
            this.name = product.name;
            this.version = product.version.orElse(null);
            this.comments = new ArrayList<String>(product.comments);
        }

        public Builder name(CharSequence name) {
            this.name = Rules.checkToken(name);
            return this;
        }

        public Builder version(@Nullable CharSequence version) {
            this.version = version != null ? Rules.checkToken(version) : null;
            return this;
        }

        public Builder comment(CharSequence comment) {
            this.comments = new ArrayList<String>(Collections.singleton(Rules.checkComment(comment)));
            return this;
        }

        public Builder addComment(CharSequence comment) {
            this.comments.add(Rules.checkComment(comment));
            return this;
        }

        public Builder addCommentText(CharSequence comment, Object ... args) {
            return this.addComment(String.format("(" + comment + ")", args));
        }

        public Builder simpleName(Class<?> type) {
            return this.name(type.getSimpleName());
        }

        public Builder implementationTitle(Class<?> type) {
            Optional<Package> pkg = Optional.ofNullable(type.getPackage());
            return this.name(pkg.map(Package::getImplementationTitle).map(ExtraFunctions.curry(Rules.TokenType.RFC7230, Rules::retainTokenChars)).orElse(type.getSimpleName()));
        }

        public Builder implementationVersion(Class<?> type) {
            Optional<Package> pkg = Optional.ofNullable(type.getPackage());
            return this.version(pkg.map(Package::getImplementationVersion).map(ExtraFunctions.curry(Rules.TokenType.RFC7230, Rules::retainTokenChars)).orElse(null));
        }

        public Product build() {
            Preconditions.checkState(this.name != null, "product name is required");
            return new Product(this);
        }

        void parse(CharSequence input) {
            int end = 0;
            this.version(null);
            this.comments.clear();
            int start = end;
            end = Rules.nextToken(Rules.TokenType.RFC7230, input, start);
            Preconditions.checkArgument(end > start, "missing name: %s", (Object)input);
            this.name(input.subSequence(start, end));
            start = end;
            if (start < input.length() && input.charAt(start++) == '/') {
                end = Rules.nextToken(Rules.TokenType.RFC7230, input, start);
                Preconditions.checkArgument(end > start, "missing version: %s", (Object)input);
                this.version(input.subSequence(start, end));
            }
            if ((start = end) < input.length()) {
                end = Rules.nextNonWsp(input, start);
                Preconditions.checkArgument(end > start, "missing RWS: %s", (Object)input);
            }
            Preconditions.checkArgument((end = Rules.remainingTokens(input, start = end, this::addComment)) == input.length(), "invalid comments: %s", (Object)input);
        }
    }
}

