/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraThrowables;
import com.blackducksoftware.common.value.RegisteredLinkRelations;
import com.blackducksoftware.common.value.Rules;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Link {
    private final String uriReference;
    private final ImmutableListMultimap<String, String> linkParams;

    private Link(Builder builder) {
        this.uriReference = Objects.requireNonNull(builder.uriReference);
        this.linkParams = ImmutableListMultimap.copyOf(Multimaps.filterValues(builder.linkParams, Objects::nonNull));
    }

    public String uriReference() {
        return this.uriReference;
    }

    public List<String> linkParams(String parmname) {
        return this.linkParams.get((Object)parmname);
    }

    public Optional<String> linkParam(String parmname) {
        return this.linkParams(parmname).stream().findFirst();
    }

    public String rel() {
        return this.linkParam("rel").get();
    }

    public int hashCode() {
        return Objects.hash(this.uriReference, this.linkParams);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link other = (Link)obj;
            return this.uriReference.equals(other.uriReference) && this.linkParams.equals(other.linkParams);
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append('<').append(this.uriReference).append('>');
        for (Map.Entry linkParam : this.linkParams.entries()) {
            result.append(';').append((String)linkParam.getKey()).append('=').append((String)linkParam.getValue());
        }
        return result.toString();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Link valueOf(String input) {
        return Link.parse(input);
    }

    public static Link parse(CharSequence input) {
        Builder builder = new Builder();
        builder.parse(input);
        return builder.build();
    }

    public static Optional<Link> tryFrom(Object obj) {
        if (obj instanceof Link) {
            return Optional.of((Link)obj);
        }
        if (obj instanceof CharSequence) {
            return Optional.ofNullable(Link.parse((CharSequence)obj));
        }
        throw new IllegalArgumentException("unexpected input: " + obj);
    }

    public static Link from(Object obj) {
        return Link.tryFrom(Objects.requireNonNull(obj)).orElseThrow(ExtraThrowables.illegalArgument("unexpected input: %s", obj));
    }

    public static class Builder {
        private static final Escaper TITLE_ESCAPER = new PercentEscaper("", false);
        private String uriReference;
        private Multimap<String, String> linkParams;

        public Builder() {
            this.linkParams = LinkedListMultimap.create();
            this.linkParams.put("rel", null);
            this.linkParams.put("anchor", null);
            this.linkParams.put("rev", null);
            this.linkParams.put("hreflang", null);
            this.linkParams.put("media", null);
            this.linkParams.put("title", null);
            this.linkParams.put("title*", null);
            this.linkParams.put("type", null);
        }

        private Builder(Link link) {
            this.uriReference = link.uriReference;
            this.linkParams = LinkedListMultimap.create(link.linkParams);
        }

        public Builder uriReference(CharSequence uriReference) {
            this.uriReference = uriReference.toString();
            return this;
        }

        public Builder linkParam(CharSequence parmname, CharSequence value) {
            String actualValue;
            switch (parmname.toString()) {
                case "rel": {
                    actualValue = Rules.checkRelationTypes(value);
                    break;
                }
                case "anchor": {
                    actualValue = Rules.checkURIReference(value);
                    break;
                }
                case "rev": {
                    actualValue = Rules.checkRelationTypes(value);
                    break;
                }
                case "hreflang": {
                    actualValue = Rules.checkLanguageTag(value);
                    break;
                }
                case "media": {
                    actualValue = Rules.checkMediaDesc(value);
                    break;
                }
                case "title": {
                    actualValue = Rules.checkQuotedString(value);
                    break;
                }
                case "title*": {
                    actualValue = Rules.checkExtValue(value);
                    break;
                }
                case "type": {
                    actualValue = Rules.checkMediaTypeOrQuotedMt(value);
                    break;
                }
                default: {
                    Rules.checkLinkExtension(parmname, value);
                    actualValue = value.toString();
                }
            }
            this.linkParams.put(parmname.toString(), actualValue);
            return this;
        }

        public Builder rel(String rel) {
            return this.linkParam("rel", rel);
        }

        public RegisteredLinkRelations rel() {
            return new RegisteredLinkRelations(this);
        }

        public Builder anchor(String anchor) {
            return this.linkParam("anchor", anchor);
        }

        public Builder hreflang(String hreflang) {
            return this.linkParam("hreflang", hreflang);
        }

        public Builder media(String media) {
            return this.linkParam("media", media);
        }

        public Builder title(String title) {
            return this.linkParam("title", title);
        }

        public Builder title(String title, Locale locale) {
            return this.linkParam("title*", "UTF-8'" + locale.toLanguageTag() + "'" + TITLE_ESCAPER.escape(title));
        }

        public Builder type(String type) {
            return this.linkParam("type", type);
        }

        public Link build() {
            return new Link(this);
        }

        void parse(CharSequence input) {
            int end = 0;
            this.linkParams.clear();
            int start = end;
            end = Rules.nextChar(input, start, '<');
            Preconditions.checkArgument(end > start, "missing start link: %s", (Object)input);
            start = end;
            end = Builder.nextUriReference(input, start);
            Preconditions.checkArgument(end > start, "missing link: %s", (Object)input);
            this.uriReference(input.subSequence(start, end));
            start = end;
            end = Rules.nextChar(input, start, '>');
            Preconditions.checkArgument(end > start, "missing end link: %s", (Object)input);
            start = end;
            end = Rules.remainingNameValues(Rules.TokenType.RFC5988, input, start, this::linkParam);
            Preconditions.checkArgument(end == input.length(), "invalid link-params: %s", (Object)input);
        }

        private static int nextUriReference(CharSequence input, int start) {
            int pos = start;
            int length = input.length();
            while (pos < length - 1) {
                if (input.charAt(++pos) != '>') continue;
                return pos;
            }
            return start;
        }
    }
}

