/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraThrowables;
import com.blackducksoftware.common.value.Rules;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.UrlEscapers;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class HID {
    private static final ImmutableSet<String> HIERARCHICAL_FRAGMENT_SCHEMES = ImmutableSet.of("zip", "jar", "tar", "rpm", "ar", "arj", new String[]{"cpio", "dump", "sevenz"});
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final Joiner PATH_JOINER = Joiner.on('/');
    private static final Splitter PATH_SPLITTER = Splitter.on('/').omitEmptyStrings();
    private static final String[] EMPTY_PATH = new String[0];
    private static final Map<String, String[]> PATH_CACHE = new LinkedHashMap<String, String[]>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String[]> eldest) {
            return this.size() > 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] computeIfAbsent(String key, Function<? super String, ? extends String[]> mappingFunction) {
            1 var3_3 = this;
            synchronized (var3_3) {
                return super.computeIfAbsent(key, mappingFunction);
            }
        }
    };
    private final String[] schemes;
    private final String[] authorities;
    private final String[][] segments;

    private static String[] toPath(String entryName) {
        boolean absolute;
        if (entryName.isEmpty()) {
            return EMPTY_PATH;
        }
        boolean bl = absolute = entryName.charAt(0) == '/';
        if (entryName.length() == 1 && (entryName.charAt(0) == '.' || absolute)) {
            return EMPTY_PATH;
        }
        ArrayList<String> path = new ArrayList<String>();
        for (String segment : PATH_SPLITTER.split(entryName)) {
            if (segment.equals("..")) {
                if (path.size() > 0 && !((String)path.get(path.size() - 1)).equals("..")) {
                    path.remove(path.size() - 1);
                    continue;
                }
                if (absolute && path.isEmpty()) continue;
                path.add("..");
                continue;
            }
            if (segment.equals(".")) continue;
            path.add(HID.normalizePathSegment(segment));
        }
        return path.toArray(EMPTY_PATH);
    }

    private static String normalizePathSegment(String segment) {
        return Normalizer.normalize(segment, Normalizer.Form.NFC);
    }

    private static int preOrderTraversal(HID left, HID right) {
        ComparisonChain compare = ComparisonChain.start();
        for (int i = 0; i < Math.min(left.segments.length, right.segments.length) && compare.result() == 0; ++i) {
            String[] leftNested = left.segments[i];
            String[] rightNested = right.segments[i];
            for (int j = 0; j < Math.min(leftNested.length, rightNested.length) && compare.result() == 0; ++j) {
                compare = compare.compare(leftNested[j], rightNested[j], HID::comparePathSegments);
            }
            compare = compare.compare(leftNested.length, rightNested.length);
        }
        compare = compare.compare(left.segments.length, right.segments.length);
        return compare.result();
    }

    private static int comparePathSegments(String left, String right) {
        return left.compareTo(right);
    }

    public static Comparator<HID> preOrder() {
        return HID::preOrderTraversal;
    }

    public static Comparator<HID> ignorePathOrder() {
        return Comparator.comparing(HID::getName, HID::comparePathSegments);
    }

    private HID(String[] schemes, String[] authorities, String[][] segments, int nesting, int depth) {
        Preconditions.checkArgument(schemes.length == authorities.length, "schemes and authorities lengths must match");
        Preconditions.checkArgument(schemes.length == segments.length, "schemes and segment lengths must match");
        Preconditions.checkArgument(segments.length > 0, "segements must not be empty");
        Preconditions.checkArgument(nesting >= 0, "nesting must be >= 0");
        Preconditions.checkArgument(depth <= segments[nesting].length, "depth cannot exceed existing segment count");
        this.schemes = Arrays.copyOf(schemes, nesting + 1);
        this.authorities = Arrays.copyOf(authorities, nesting + 1);
        this.segments = (String[][])Arrays.copyOf(segments, nesting + 1);
        this.segments[nesting] = Arrays.copyOf(segments[nesting], depth < 0 ? segments[nesting].length : depth);
    }

    @VisibleForTesting
    int nesting() {
        return this.segments.length - 1;
    }

    @VisibleForTesting
    int depth() {
        return this.segments[this.nesting()].length;
    }

    private HID parent() {
        assert (this.depth() > 0);
        return new HID(this.schemes, this.authorities, this.segments, this.nesting(), this.depth() - 1);
    }

    private HID container() {
        assert (this.nesting() > 0);
        return new HID(this.schemes, this.authorities, this.segments, this.nesting() - 1, -1);
    }

    public String getScheme() {
        return this.schemes[this.nesting()];
    }

    public String getName() {
        return this.segments[this.nesting()].length > 0 ? this.segments[this.nesting()][this.depth() - 1] : "/";
    }

    public String getPath() {
        return PATH_JOINER.appendTo(new StringBuilder().append('/'), this.segments[this.nesting()]).toString();
    }

    public List<String> getPathNames() {
        return Collections.unmodifiableList(Arrays.asList(this.segments[this.nesting()]));
    }

    public List<String> getContainerNames() {
        String[] result = new String[this.nesting()];
        for (int i = 0; i < result.length; ++i) {
            int j = this.segments.length - i - 2;
            result[i] = this.segments[j][this.segments[j].length - 1];
        }
        return Collections.unmodifiableList(Arrays.asList(result));
    }

    public boolean containsPathNames(String ... names) {
        int max = this.depth() - names.length;
        block0: for (int index = 0; index <= max; ++index) {
            int i = 0;
            int j = index;
            while (i < names.length) {
                if (!names[i].equals(this.segments[this.nesting()][j])) continue block0;
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getRelativizedPath(HID other) {
        if (this.nesting() == other.nesting() && other.isAncestor(this)) {
            return PATH_JOINER.join(Arrays.asList(other.segments[this.nesting()]).subList(this.depth(), other.depth()));
        }
        return null;
    }

    public HID getRebased(HID oldBase, HID newBase) {
        if (oldBase.equals(newBase)) {
            return this;
        }
        Preconditions.checkArgument(this.isAncestor(oldBase), "must rebase from an ancestor: %s is not an ancestor of %s", (Object)oldBase, (Object)this);
        int nesting = this.nesting() - oldBase.nesting() + newBase.nesting();
        int depth = this.segments[oldBase.nesting()].length - oldBase.depth() + newBase.depth();
        String[] schemes = new String[nesting + 1];
        String[] authorities = new String[nesting + 1];
        String[][] segments = new String[nesting + 1][];
        segments[newBase.nesting()] = new String[depth];
        System.arraycopy(newBase.schemes, 0, schemes, 0, newBase.nesting() + 1);
        System.arraycopy(newBase.authorities, 0, authorities, 0, newBase.nesting() + 1);
        System.arraycopy(newBase.segments, 0, segments, 0, newBase.nesting());
        System.arraycopy(newBase.segments[newBase.nesting()], 0, segments[newBase.nesting()], 0, newBase.depth());
        System.arraycopy(this.schemes, oldBase.nesting() + 1, schemes, newBase.nesting() + 1, nesting - newBase.nesting());
        System.arraycopy(this.authorities, oldBase.nesting() + 1, authorities, newBase.nesting() + 1, nesting - newBase.nesting());
        System.arraycopy(this.segments, oldBase.nesting() + 1, segments, newBase.nesting() + 1, nesting - newBase.nesting());
        System.arraycopy(this.segments[oldBase.nesting()], oldBase.depth(), segments[newBase.nesting()], newBase.depth(), depth - newBase.depth());
        return new HID(schemes, authorities, segments, nesting, -1);
    }

    @Nullable
    public HID getParent() {
        if (this.isRoot()) {
            return this.getContainer();
        }
        return this.parent();
    }

    public Optional<HID> tryParent() {
        if (this.isRoot()) {
            return this.tryContainer();
        }
        return Optional.of(this.parent());
    }

    @Deprecated
    public boolean hasParent() {
        return !this.isRoot();
    }

    public HID getRoot() {
        if (this.isRoot()) {
            return this;
        }
        return new HID(this.schemes, this.authorities, this.segments, this.nesting(), 0);
    }

    public boolean isRoot() {
        return this.depth() == 0;
    }

    @Nullable
    public HID getContainer() {
        if (this.hasContainer()) {
            return this.container();
        }
        return null;
    }

    public Optional<HID> tryContainer() {
        if (this.hasContainer()) {
            return Optional.of(this.container());
        }
        return Optional.empty();
    }

    public boolean hasContainer() {
        return this.nesting() > 0;
    }

    public HID getBase() {
        if (this.hasContainer()) {
            return new HID(this.schemes, this.authorities, this.segments, 0, -1);
        }
        return this;
    }

    public boolean isAncestor(HID other) {
        int otherNesting = other.nesting();
        if (this.nesting() < otherNesting || this.segments[otherNesting].length < other.segments[otherNesting].length) {
            return false;
        }
        for (int i = 0; i < otherNesting; ++i) {
            if (Arrays.equals(this.segments[i], other.segments[i])) continue;
            return false;
        }
        int otherDepth = other.depth();
        for (int i = 0; i < otherDepth; ++i) {
            if (this.segments[otherNesting][i].equals(other.segments[otherNesting][i])) continue;
            return false;
        }
        return this.depth() > other.depth() || this.nesting() > other.nesting();
    }

    public String toUriString() {
        StringBuilder buffer = new StringBuilder(128).append(this.schemes[0]).append("://").append(this.authorities[0]).append('/');
        String result = PATH_JOINER.appendTo(buffer, Stream.of(this.segments[0]).map(UrlEscapers.urlPathSegmentEscaper()::escape).iterator()).toString();
        for (int i = 1; i < this.segments.length; ++i) {
            buffer.setLength(0);
            result = buffer.append(this.schemes[i]).append(':').append(UrlEscapers.urlPathSegmentEscaper().escape(result)).append("#/").append(UrlEscapers.urlFragmentEscaper().escape(PATH_JOINER.join(this.segments[i]))).toString();
        }
        return result;
    }

    public URI toUri() {
        return URI.create(this.toUriString());
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("[ ");
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                string.append(", ");
            }
            string.append(this.schemes[i]).append(":/");
            if (!this.authorities[i].isEmpty()) {
                string.append('/').append(this.authorities[i]).append('/');
            }
            PATH_JOINER.appendTo(string, this.segments[i]);
        }
        string.append(" ]");
        return string.toString();
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.schemes), Arrays.hashCode(this.authorities), Arrays.deepHashCode((Object[])this.segments));
    }

    public boolean equals(Object obj) {
        if (obj instanceof HID) {
            HID other = (HID)obj;
            return Arrays.equals(this.schemes, other.schemes) && Arrays.equals(this.authorities, other.authorities) && Arrays.deepEquals((Object[])this.segments, (Object[])other.segments);
        }
        return false;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static HID of(URI uri) {
        return new Builder().parseUri(uri).build();
    }

    public static HID of(Path path) {
        return new Builder().parseUri(path.toUri()).build();
    }

    public static HID valueOf(String input) {
        return HID.parse(input);
    }

    public static HID parse(CharSequence input) {
        return new Builder().parse(input).build();
    }

    public static Optional<HID> tryFrom(@Nullable Object obj) {
        if (obj instanceof HID) {
            return Optional.of((HID)obj);
        }
        if (obj instanceof URI) {
            return Optional.of(HID.of((URI)obj));
        }
        if (obj instanceof Path) {
            return Optional.of(HID.of((Path)obj));
        }
        if (obj instanceof CharSequence) {
            return Optional.of(HID.parse((CharSequence)obj));
        }
        return Optional.empty();
    }

    public static HID from(Object obj) {
        return HID.tryFrom(Objects.requireNonNull(obj)).orElseThrow(ExtraThrowables.illegalArgument("unexpected input: %s", obj));
    }

    public static class Builder {
        private static final int DEFAULT_CAPACITY = 10;
        private String[] schemes;
        private String[] authorities;
        private String[][] segments;
        private int size = -1;

        public Builder() {
            this(10);
        }

        private Builder(HID hid) {
            this(Builder.computeCapacity(10, hid.schemes.length));
            System.arraycopy(hid.schemes, 0, this.schemes, 0, hid.schemes.length);
            System.arraycopy(hid.authorities, 0, this.authorities, 0, hid.authorities.length);
            System.arraycopy(hid.segments, 0, this.segments, 0, hid.segments.length);
            this.size = hid.schemes.length - 1;
        }

        private Builder(int capacity) {
            this.schemes = new String[capacity];
            this.authorities = new String[capacity];
            this.segments = new String[capacity][];
        }

        public Builder push(CharSequence scheme, @Nullable String authority, String path) {
            this.ensureCapacity(++this.size + 1);
            this.schemes[this.size] = Rules.checkScheme(scheme);
            this.authorities[this.size] = Strings.nullToEmpty(authority);
            this.segments[this.size] = PATH_CACHE.computeIfAbsent(Objects.requireNonNull(path), x$0 -> HID.toPath(x$0));
            return this;
        }

        public Builder push(CharSequence scheme, String path) {
            return this.push(scheme, null, path);
        }

        public Builder resolve(String path) {
            String[] newSegments = HID.toPath(path);
            if (path.charAt(0) == '/') {
                this.segments[this.size] = newSegments;
            } else {
                int srcPos = 0;
                while (newSegments[srcPos].equals("..")) {
                    ++srcPos;
                }
                int destPos = this.segments[this.size].length - srcPos;
                int length = newSegments.length - srcPos;
                this.segments[this.size] = Arrays.copyOf(this.segments[this.size], destPos + length);
                System.arraycopy(newSegments, srcPos, this.segments[this.size], destPos, length);
            }
            return this;
        }

        @Nullable
        public String peekFilename() {
            return this.size < 0 ? null : this.segments[this.size][this.segments[this.size].length - 1];
        }

        public Builder pop() {
            if (this.size < 0) {
                throw new NoSuchElementException();
            }
            this.schemes[this.size] = null;
            this.authorities[this.size] = null;
            this.segments[this.size] = null;
            --this.size;
            return this;
        }

        public HID build() {
            return new HID(this.schemes, this.authorities, this.segments, this.size, -1);
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity - this.schemes.length >= 0) {
                int newCapacity = Builder.computeCapacity(minCapacity, this.schemes.length);
                this.schemes = Arrays.copyOf(this.schemes, newCapacity);
                this.authorities = Arrays.copyOf(this.authorities, newCapacity);
                this.segments = (String[][])Arrays.copyOf(this.segments, newCapacity);
            }
        }

        private Builder parseUri(URI uri) {
            Preconditions.checkArgument(uri.isAbsolute(), "URI must be absolute: %s", (Object)uri);
            String scheme = Ascii.toLowerCase(uri.getScheme());
            String fragment = uri.getFragment();
            if (fragment != null && (HIERARCHICAL_FRAGMENT_SCHEMES.contains(scheme) || fragment.startsWith("/"))) {
                return this.parse(uri.getSchemeSpecificPart()).push(scheme, fragment);
            }
            if (scheme.equals("jar")) {
                return this.parseJarUrl(uri.toString());
            }
            Preconditions.checkArgument(Strings.isNullOrEmpty(fragment), "fragment must be empty or start with '/': %s", (Object)uri);
            Preconditions.checkArgument(Strings.isNullOrEmpty(uri.getQuery()), "query must be empty: %s", (Object)uri);
            Preconditions.checkArgument(!Strings.isNullOrEmpty(uri.getPath()), "path must not be empty: %s", (Object)uri);
            return this.push(scheme, uri.getAuthority(), uri.getPath());
        }

        private Builder parseJarUrl(String url) {
            try {
                String spec = new URL(url).getFile();
                int separator = spec.indexOf("!/");
                if (separator == -1) {
                    throw new MalformedURLException("no !/ found in url spec:" + spec);
                }
                this.parse(new URL(spec.substring(0, separator++)).toString());
                String entryName = null;
                if (++separator != spec.length()) {
                    entryName = spec.substring(separator, spec.length());
                    entryName = URLDecoder.decode(entryName, "UTF-8");
                }
                return this.push("jar", entryName);
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                throw new IllegalArgumentException("bad JAR URL", e);
            }
        }

        private Builder parse(CharSequence input) {
            this.parseUri(URI.create(input.toString()));
            return this;
        }

        private static int computeCapacity(int minCapacity, int currentCapacity) {
            return Math.max(minCapacity, Math.addExact(currentCapacity, currentCapacity >> 1));
        }
    }
}

