/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraThrowables;
import com.blackducksoftware.common.value.Rules;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class Digest {
    private final String algorithm;
    private final String value;

    private Digest(Builder builder) {
        this.algorithm = Ascii.toLowerCase(builder.algorithm);
        this.value = Objects.requireNonNull(builder.value);
    }

    public String algorithm() {
        return this.algorithm;
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Digest) {
            Digest other = (Digest)obj;
            return this.algorithm.equals(other.algorithm) && this.value.equals(other.value);
        }
        return false;
    }

    public String toString() {
        return this.algorithm + ':' + this.value;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Digest of(CharSequence algorithm, CharSequence value) {
        return new Builder().algorithm(algorithm).value(value).build();
    }

    public static Digest valueOf(String input) {
        return Digest.parse(input);
    }

    public static Digest parse(CharSequence input) {
        Builder builder = new Builder();
        builder.parse(input);
        return builder.build();
    }

    public static Optional<Digest> tryFrom(@Nullable Object obj) {
        if (obj instanceof Digest) {
            return Optional.of((Digest)obj);
        }
        if (obj instanceof CharSequence) {
            return Optional.of(Digest.parse((CharSequence)obj));
        }
        return Optional.empty();
    }

    public static Digest from(Object obj) {
        return Digest.tryFrom(Objects.requireNonNull(obj)).orElseThrow(ExtraThrowables.illegalArgument("unexpected input: %s", obj));
    }

    public static class Builder {
        private static final CharMatcher ALGORITHM_CHARS = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("_+.-"));
        private String algorithm;
        private String value;

        public Builder() {
        }

        private Builder(Digest digest) {
            this.algorithm = digest.algorithm;
            this.value = digest.value;
        }

        public Builder algorithm(@Nullable CharSequence algorithm) {
            this.algorithm = algorithm != null ? Builder.checkAlgorithm(algorithm) : null;
            return this;
        }

        public Builder value(@Nullable CharSequence value) {
            this.value = value != null ? Builder.checkValue(value) : null;
            return this;
        }

        public Digest build() {
            return new Digest(this);
        }

        void parse(CharSequence input) {
            int end = 0;
            int start = end;
            end = Rules.next(input, ALGORITHM_CHARS, start);
            Preconditions.checkArgument(end > start, "missing algorithm: %s", (Object)input);
            this.algorithm(input.subSequence(start, end));
            start = end;
            end = Rules.nextChar(input, start, ':');
            Preconditions.checkArgument(end > start, "missing delimiter: %s", (Object)input);
            start = end;
            end = input.length();
            this.value(input.subSequence(start, end));
        }

        private static String checkAlgorithm(@Nullable CharSequence input) {
            Preconditions.checkArgument(input != null, "null algorithm");
            Preconditions.checkArgument(input.length() > 0 && ALGORITHM_CHARS.matchesAllOf(input), "invalid algorithm: %s", (Object)input);
            return input.toString();
        }

        private static String checkValue(@Nullable CharSequence input) {
            Preconditions.checkArgument(input != null, "null value");
            Preconditions.checkArgument(input.length() > 0, "invalid value: <empty>");
            return input.toString();
        }
    }
}

