/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraThrowables;
import com.blackducksoftware.common.value.Rules;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class ContentRange {
    private ContentRange(Builder builder) {
    }

    public abstract String unit();

    public abstract String range();

    public int hashCode() {
        return Objects.hash(this.unit(), this.range());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContentRange) {
            ContentRange other = (ContentRange)obj;
            return this.unit().equals(other.unit()) && this.range().equals(other.range());
        }
        return false;
    }

    public String toString() {
        return this.unit() + ' ' + this.range();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static ContentRange valueOf(String input) {
        return ContentRange.parse(input);
    }

    public static ContentRange parse(CharSequence input) {
        Builder builder = new Builder();
        builder.parse(input);
        return builder.build();
    }

    public static Optional<ContentRange> tryFrom(@Nullable Object obj) {
        if (obj instanceof ContentRange) {
            return Optional.of((ContentRange)obj);
        }
        if (obj instanceof CharSequence) {
            return Optional.of(ContentRange.parse((CharSequence)obj));
        }
        return Optional.empty();
    }

    public static ContentRange from(Object obj) {
        return ContentRange.tryFrom(Objects.requireNonNull(obj)).orElseThrow(ExtraThrowables.illegalArgument("unexpected input: %s", obj));
    }

    public static class Builder {
        private String unit;
        private String otherRange;
        private long firstByte;
        private long lastByte;
        private long contentLength;

        public Builder() {
            this.unit = "bytes";
            this.firstByte = -1L;
            this.lastByte = -1L;
            this.contentLength = -1L;
        }

        private Builder(ContentRange contentRange) {
            this.unit = contentRange.unit();
            if (contentRange instanceof ByteContentRange) {
                ByteContentRange byteRange = (ByteContentRange)contentRange;
                this.firstByte = byteRange.firstBytePos;
                this.lastByte = byteRange.lastBytePos;
                this.contentLength = byteRange.completeLength;
            } else {
                this.otherRange = contentRange.range();
            }
        }

        public Builder byteRange(long firstByte, long lastByte, long contentLength) {
            Preconditions.checkArgument(firstByte >= 0L, "invalid first-byte-pos: %s", firstByte);
            Preconditions.checkArgument(lastByte >= firstByte, "invalid last-byte-pos: %s", lastByte);
            Preconditions.checkArgument(contentLength > lastByte, "invalid content-length: %s", contentLength);
            this.firstByte = firstByte;
            this.lastByte = lastByte;
            this.contentLength = contentLength;
            return this.unit("bytes");
        }

        public Builder unsatisifiedByteRange(long contentLength) {
            Preconditions.checkArgument(contentLength >= 0L, "invalid content-length: %s", contentLength);
            this.firstByte = -1L;
            this.lastByte = -1L;
            this.contentLength = contentLength;
            return this.unit("bytes");
        }

        public Builder unknownLengthByteRange(long firstByte, long lastByte) {
            Preconditions.checkArgument(firstByte >= 0L, "invalid first-byte-pos: %s", firstByte);
            Preconditions.checkArgument(lastByte >= firstByte, "invalid last-byte-pos: %s", lastByte);
            this.firstByte = firstByte;
            this.lastByte = lastByte;
            this.contentLength = -1L;
            return this.unit("bytes");
        }

        public Builder otherRange(String unit, String range) {
            this.otherRange = range;
            return this.unit(unit);
        }

        public ContentRange build() {
            if (Rules.isBytesUnit(this.unit)) {
                return new ByteContentRange(this);
            }
            return new OtherContentRange(this);
        }

        private Builder unit(CharSequence unit) {
            this.unit = Rules.isBytesUnit(unit) ? unit.toString() : Rules.checkOtherRangeUnit(unit);
            return this;
        }

        void parse(CharSequence input) {
            int end = 0;
            int start = end;
            end = Rules.nextToken(Rules.TokenType.RFC7230, input, start);
            Preconditions.checkArgument(end > start, "missing unit: %s", (Object)input);
            this.unit(input.subSequence(start, end));
            start = end;
            end = Rules.nextChar(input, start, ' ');
            Preconditions.checkArgument(end > start, "missing delimiter: %s", (Object)input);
            int length = input.length();
            if (Rules.isBytesUnit(this.unit)) {
                start = end;
                if ((end = Builder.nextUnknown(input, start, "byte-range-res")) > start) {
                    this.lastByte = -1L;
                    this.firstByte = -1L;
                } else {
                    end = Rules.nextDigit(input, start);
                    Preconditions.checkArgument(end > start, "missing first-byte-pos: %s", (Object)input);
                    this.firstByte = Long.parseLong(input.subSequence(start, end).toString());
                    start = end;
                    end = Rules.nextChar(input, start, '-');
                    Preconditions.checkArgument(end > start, "missing byte-range delimiter: %s", (Object)input);
                    start = end;
                    end = Rules.nextDigit(input, start);
                    Preconditions.checkArgument(end > start, "missing last-byte-pos: %s", (Object)input);
                    this.lastByte = Long.parseLong(input.subSequence(start, end).toString());
                }
                start = end;
                end = Rules.nextChar(input, start, '/');
                Preconditions.checkArgument(end > start, "missing byte-range-resp delimiter: %s", (Object)input);
                start = end;
                end = Builder.nextUnknown(input, start, "complete-length");
                if (end > start) {
                    this.contentLength = -1L;
                } else {
                    end = Rules.nextDigit(input, start);
                    Preconditions.checkArgument(end > start, "missing content-length: %s", (Object)input);
                    this.contentLength = Long.parseLong(input.subSequence(start, end).toString());
                }
            } else {
                start = end;
                end = length;
                this.otherRange = input.subSequence(start, end).toString();
            }
        }

        private static int nextUnknown(CharSequence input, int start, String rule) {
            Preconditions.checkArgument(start < input.length(), "missing %s: %s", (Object)rule, (Object)input);
            return input.charAt(start) == '*' ? start + 1 : start;
        }
    }

    public static final class OtherContentRange
    extends ContentRange {
        private final String unit;
        private final String range;

        private OtherContentRange(Builder builder) {
            super(builder);
            this.unit = Objects.requireNonNull(builder.unit);
            this.range = Objects.requireNonNull(builder.otherRange);
        }

        @Override
        public String unit() {
            return this.unit;
        }

        @Override
        public String range() {
            return this.range;
        }
    }

    public static final class ByteContentRange
    extends ContentRange {
        private final long firstBytePos;
        private final long lastBytePos;
        private final long completeLength;

        private ByteContentRange(Builder builder) {
            super(builder);
            ByteContentRange.checkByteRange(builder.firstByte, builder.lastByte, builder.contentLength);
            this.firstBytePos = builder.firstByte;
            this.lastBytePos = builder.lastByte;
            this.completeLength = builder.contentLength;
        }

        private static void checkByteRange(long firstByte, long lastByte, long contentLength) {
            if (firstByte < 0L && lastByte < 0L) {
                Preconditions.checkArgument(contentLength >= 0L, "unsatisfied range must have content-length");
            } else {
                Preconditions.checkArgument(firstByte <= lastByte, "invalid byte-range: %s-%s", firstByte, lastByte);
                Preconditions.checkArgument(contentLength < 0L || contentLength > lastByte, "invalid byte-range: %s-%s/%s", (Object)firstByte, (Object)lastByte, (Object)contentLength);
            }
        }

        @Override
        public String unit() {
            return "bytes";
        }

        @Override
        public String range() {
            if (this.isUnsatisfied()) {
                return "*/" + this.completeLength;
            }
            return this.firstBytePos + "-" + this.lastBytePos + '/' + (this.completeLength < 0L ? 42L : this.completeLength);
        }

        public boolean isUnknownLength() {
            return this.completeLength < 0L;
        }

        public boolean isUnsatisfied() {
            return this.firstBytePos < 0L && this.lastBytePos < 0L && !this.isUnknownLength();
        }

        public long firstBytePos() {
            return this.firstBytePos;
        }

        public long lastBytePos() {
            return this.lastBytePos;
        }

        public long completeLength() {
            return this.completeLength;
        }
    }
}

