/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.security.cert;

import com.blackducksoftware.common.base.ExtraStreams;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class X509Certificates {
    public static Optional<String> subjectCommonName(X509Certificate certificate) {
        try {
            LdapName subjectName = new LdapName(certificate.getSubjectX500Principal().getName("RFC2253"));
            for (Rdn rdn : subjectName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                return Optional.of(rdn.getValue().toString());
            }
            return Optional.empty();
        }
        catch (InvalidNameException e) {
            return Optional.empty();
        }
    }

    public static Stream<byte[]> subjectAlternativeOtherNames(X509Certificate certificate) {
        return X509Certificates.subjectAlternativeNames(certificate).flatMap(GeneralName.other::toByteArray);
    }

    public static Stream<String> subjectAlternativeRfc822Names(X509Certificate certificate) {
        return X509Certificates.subjectAlternativeNames(certificate).flatMap(GeneralName.rfc822Name::toString);
    }

    public static Stream<String> subjectAlternativeDnsNames(X509Certificate certificate) {
        return X509Certificates.subjectAlternativeNames(certificate).flatMap(GeneralName.dNSName::toString);
    }

    private static Stream<List<?>> subjectAlternativeNames(X509Certificate certificate) {
        try {
            return ExtraStreams.streamNullable(certificate.getSubjectAlternativeNames());
        }
        catch (CertificateParsingException e) {
            return Stream.empty();
        }
    }

    private X509Certificates() {
        assert (false);
    }

    private static enum GeneralName {
        other(0, false),
        rfc822Name(1, true),
        dNSName(2, true),
        x400Address(3, false),
        directoryName(4, true),
        ediPartyName(5, false),
        uniformResourceIdentifier(6, true),
        iPAddress(7, true),
        registeredID(8, true);

        private final Integer i;
        private final boolean string;

        private GeneralName(int i, boolean string2) {
            this.i = i;
            this.string = string2;
        }

        public Stream<String> toString(List<?> generalName) {
            Preconditions.checkState(this.string, "cannot call toString(List<?>) on %s", (Object)this.name());
            GeneralName.verifyGeneralName(generalName);
            return generalName.get(0).equals(this.i) ? Stream.of((String)generalName.get(1)) : Stream.empty();
        }

        public Stream<byte[]> toByteArray(List<?> generalName) {
            Preconditions.checkState(!this.string, "cannot call toByteArray(List<?>) on %s", (Object)this.name());
            GeneralName.verifyGeneralName(generalName);
            return generalName.get(0).equals(this.i) ? Stream.of((byte[])generalName.get(1)) : Stream.empty();
        }

        private static void verifyGeneralName(List<?> generalName) {
            Verify.verify(generalName.size() == 2);
            Verify.verify(generalName.get(0) instanceof Integer);
            Verify.verify(generalName.get(1) instanceof String || generalName.get(1) instanceof byte[]);
        }
    }
}

