/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.security.auth;

import com.blackducksoftware.common.security.auth.EnumChoiceCallback;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Optional;
import java.util.ResourceBundle;

public abstract class InvalidCertificateCallback
extends EnumChoiceCallback<Choice> {
    private static final long serialVersionUID = 8864038835200227083L;

    protected InvalidCertificateCallback(String host) {
        super(InvalidCertificateCallback.prompt(host), Choice.class, Choice.NEVER, false, ResourceBundle.getBundle(InvalidCertificateCallbackBundle.class.getName()));
    }

    private static final String prompt(String host) {
        ResourceBundle bundle = ResourceBundle.getBundle(InvalidCertificateCallbackBundle.class.getName());
        return MessageFormat.format(bundle.getString("prompt"), host);
    }

    @Override
    public Optional<Choice> getSelectedChoice() {
        Optional selectedChoice = super.getSelectedChoice();
        return selectedChoice.isPresent() ? selectedChoice : Optional.of(Choice.NEVER);
    }

    public static final class InvalidCertificateCallbackBundle
    extends ListResourceBundle {
        @Override
        protected Object[][] getContents() {
            return new Object[][]{{"NEVER", "Cancel"}, {"ONCE", "Continue"}, {"ALWAYS", "Always Connect"}, {"prompt", "Cannot verify the identity of the server \"{0}\". The certificate for this server is invalid. Would you like to connect anyway?"}};
        }
    }

    public static enum Choice {
        NEVER,
        ONCE,
        ALWAYS;

    }
}

