/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class KeyPairStore {
    private static final Splitter PEM_ENCAPSULATED_DATA_SPLITTER = Splitter.on(':').trimResults().limit(2).omitEmptyStrings();

    private KeyPairStore() {
    }

    private static void checkPrivateKeyPermissions(Path keyFile) {
        Objects.requireNonNull(keyFile);
    }

    @VisibleForTesting
    protected static KeySpec keySpec(byte[] keyMaterial, @Nullable char[] password) throws InvalidKeySpecException, UnrecoverableKeyException {
        if (Bytes.indexOf(keyMaterial, new byte[]{45, 45, 45, 45, 45}) < 0) {
            return KeyPairStore.derEncodedKeySpec(keyMaterial, password);
        }
        return KeyPairStore.pemEncodedKeySpec(keyMaterial, password);
    }

    private static KeySpec derEncodedKeySpec(byte[] keyMaterial, @Nullable char[] password) throws InvalidKeySpecException, UnrecoverableKeyException {
        if (password == null || password.length == 0) {
            try {
                return KeyPairStore.rsaPrivateKeySpec(keyMaterial);
            }
            catch (InvalidKeySpecException e) {
                return new PKCS8EncodedKeySpec(keyMaterial);
            }
        }
        try {
            EncryptedPrivateKeyInfo privateKeyInfo = new EncryptedPrivateKeyInfo(keyMaterial);
            SecretKeySpec decryptKey = new SecretKeySpec(new String(password).getBytes(Charset.defaultCharset()), KeyPairStore.algorithmName(privateKeyInfo));
            return privateKeyInfo.getKeySpec(decryptKey);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("overrun, ")) {
                UnrecoverableKeyException failure = new UnrecoverableKeyException("bad password");
                failure.addSuppressed(e);
                throw failure;
            }
            return new PKCS8EncodedKeySpec(keyMaterial);
        }
        catch (InvalidKeyException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("bad password").initCause(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("unsupported key encryption algorithm").initCause(e);
        }
    }

    private static KeySpec pemEncodedKeySpec(byte[] keyMaterial, @Nullable char[] password) throws InvalidKeySpecException, UnrecoverableKeyException {
        ArrayList<String> base64 = null;
        String label = null;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try {
            for (String line : ByteSource.wrap(keyMaterial).asCharSource(StandardCharsets.US_ASCII).readLines()) {
                if ((line = line.trim()).startsWith("-----BEGIN ") && line.endsWith("-----")) {
                    base64 = new ArrayList<String>();
                    label = line.substring(11, line.length() - 5);
                    continue;
                }
                if (base64 == null || !line.equals("-----END " + label + "-----")) {
                    if (base64 == null) continue;
                    List<String> keyValue = PEM_ENCAPSULATED_DATA_SPLITTER.splitToList(line);
                    if (keyValue.size() == 1) {
                        base64.add(keyValue.get(0));
                        continue;
                    }
                    if (keyValue.size() != 2) continue;
                    properties.put(keyValue.get(0).toLowerCase(), keyValue.get(1));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new InvalidKeySpecException("invalid textual encoding", e);
        }
        if (base64 == null || label == null) {
            throw new InvalidKeySpecException("unable to find encapsulated data");
        }
        byte[] encodedKey = BaseEncoding.base64().decode(Joiner.on("").join(base64));
        return KeyPairStore.pemKeySpec(encodedKey, label, properties, password);
    }

    private static KeySpec pemKeySpec(byte[] encodedKey, String label, Map<String, String> properties, char[] password) throws InvalidKeySpecException, UnrecoverableKeyException {
        switch (label) {
            case "RSA PRIVATE KEY": {
                byte[] decryptedKey;
                if (properties.isEmpty()) {
                    return KeyPairStore.rsaPrivateKeySpec(encodedKey);
                }
                try {
                    String procType = properties.get("proc-type");
                    String dekInfo = properties.get("dek-info");
                    decryptedKey = KeyPairStore.generateOpenSSLCipher(procType, dekInfo, password).doFinal(encodedKey);
                }
                catch (BadPaddingException e) {
                    throw (UnrecoverableKeyException)new UnrecoverableKeyException("bad password").initCause(e);
                }
                catch (IllegalArgumentException | GeneralSecurityException e) {
                    throw (UnrecoverableKeyException)new UnrecoverableKeyException("failed to read encrypted traditional RSA private key").initCause(e);
                }
                return KeyPairStore.rsaPrivateKeySpec(decryptedKey);
            }
            case "PRIVATE KEY": {
                return new PKCS8EncodedKeySpec(encodedKey);
            }
            case "ENCRYPTED PRIVATE KEY": {
                if (password != null) {
                    try {
                        EncryptedPrivateKeyInfo privateKeyInfo = new EncryptedPrivateKeyInfo(encodedKey);
                        SecretKeySpec decryptKey = new SecretKeySpec(new String(password).getBytes(Charset.defaultCharset()), KeyPairStore.algorithmName(privateKeyInfo));
                        return privateKeyInfo.getKeySpec(decryptKey);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw (UnrecoverableKeyException)new UnrecoverableKeyException("unsupported key encryption algorithm").initCause(e);
                    }
                    catch (InvalidKeyException e) {
                        throw (UnrecoverableKeyException)new UnrecoverableKeyException("bad password").initCause(e);
                    }
                    catch (IOException e) {
                        throw new InvalidKeySpecException("invalid encrypted private key", e);
                    }
                }
                throw new UnrecoverableKeyException("no password");
            }
        }
        throw new InvalidKeySpecException("unknown label: " + label);
    }

    @VisibleForTesting
    protected static String algorithm(KeySpec keySpec) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (keySpec instanceof RSAPrivateKeySpec) {
            return "RSA";
        }
        if (keySpec instanceof DSAPrivateKeySpec) {
            return "DSA";
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            return KeyPairStore.pkcs8PrivateKeyAlgorithm((PKCS8EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("unrecognized key specification: " + keySpec.getClass().getName());
    }

    private static String pkcs8PrivateKeyAlgorithm(PKCS8EncodedKeySpec keySpec) throws InvalidKeySpecException, NoSuchAlgorithmException {
        ByteBuffer encoded = ByteBuffer.wrap(keySpec.getEncoded());
        KeyPairStore.expectTag(encoded, (byte)48);
        if (KeyPairStore.expectTag(encoded, (byte)2) != 1 || encoded.get() != 0) {
            throw new InvalidKeySpecException("PKCS #8 private key info, expected version 0");
        }
        KeyPairStore.expectTag(encoded, (byte)48);
        int len = KeyPairStore.expectTag(encoded, (byte)6);
        String oid = KeyPairStore.readOid((ByteBuffer)encoded.slice().limit(len));
        encoded.position(encoded.position() + len);
        return KeyPairStore.oidToJcaAlgorithm(oid);
    }

    private static String algorithmName(EncryptedPrivateKeyInfo privateKeyInfo) throws NoSuchAlgorithmException {
        String algName;
        switch (algName = privateKeyInfo.getAlgName()) {
            case "1.2.840.113549.1.5.13": {
                throw new NoSuchAlgorithmException("PBES2");
            }
        }
        return algName;
    }

    private static String oidToJcaAlgorithm(String oid) throws NoSuchAlgorithmException {
        switch (oid) {
            case "1.2.840.113549.1.1.1": {
                return "RSA";
            }
            case "1.2.840.10040.4.1": {
                return "DSA";
            }
        }
        throw new NoSuchAlgorithmException(oid);
    }

    private static RSAPrivateKeySpec rsaPrivateKeySpec(byte[] encodedKey) throws InvalidKeySpecException {
        ByteBuffer encoded = ByteBuffer.wrap(encodedKey);
        KeyPairStore.expectTag(encoded, (byte)48);
        if (KeyPairStore.expectTag(encoded, (byte)2) != 1 || encoded.get() != 0) {
            throw new InvalidKeySpecException("PKCS #1 private key info, expected version 0");
        }
        int modulusLength = KeyPairStore.expectTag(encoded, (byte)2);
        BigInteger modulus = KeyPairStore.readInteger((ByteBuffer)encoded.slice().limit(modulusLength));
        encoded.position(encoded.position() + modulusLength);
        int publicExponentLength = KeyPairStore.expectTag(encoded, (byte)2);
        KeyPairStore.readInteger((ByteBuffer)encoded.slice().limit(publicExponentLength));
        encoded.position(encoded.position() + publicExponentLength);
        int privateExponentLength = KeyPairStore.expectTag(encoded, (byte)2);
        BigInteger privateExponent = KeyPairStore.readInteger((ByteBuffer)encoded.slice().limit(privateExponentLength));
        encoded.position(encoded.position() + privateExponentLength);
        return new RSAPrivateKeySpec(modulus, privateExponent);
    }

    private static int expectTag(ByteBuffer buffer, byte tag) throws InvalidKeySpecException {
        if (buffer.get() != tag) {
            throw new InvalidKeySpecException(String.format("expected 0x%02X, was 0x%02X", tag & 0xFF, buffer.get(buffer.position() - 1)));
        }
        int result = buffer.get();
        if ((result & 0x80) != 0) {
            byte[] buf = new byte[result & 0x7F];
            buffer.get(buf);
            result = 0;
            for (byte b : buf) {
                result = result << 8 | b & 0xFF;
            }
        }
        return result;
    }

    private static String readOid(ByteBuffer buffer) {
        StringBuilder oid = new StringBuilder();
        byte firstTwoNodes = buffer.get();
        oid.append(firstTwoNodes / 40).append('.').append(firstTwoNodes % 40);
        int o = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if ((b & 0x80) != 0) {
                o = o << 7 | b & 0x7F;
                continue;
            }
            if (o != 0) {
                oid.append('.').append(o << 7 | b & 0x7F);
                o = 0;
                continue;
            }
            oid.append('.').append(b);
        }
        return oid.toString();
    }

    private static BigInteger readInteger(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new BigInteger(bytes);
    }

    private static Cipher generateOpenSSLCipher(String procType, String dekInfo, char[] password) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        int len;
        List<String> dekInfos = Splitter.on(',').trimResults().limit(2).splitToList(Strings.nullToEmpty(dekInfo));
        List<String> opensslAlgorithm = Splitter.on('-').splitToList(dekInfos.get(0).toUpperCase());
        byte[] iv = BaseEncoding.base16().decode(dekInfos.get(1));
        if (opensslAlgorithm.isEmpty()) {
            throw new NoSuchAlgorithmException("UNKNOWN (DEK-Info: " + dekInfo + ")");
        }
        String algorithm = opensslAlgorithm.get(0);
        String mode = "CBC";
        String padding = "PKCS5Padding";
        Integer keySize = null;
        if (opensslAlgorithm.size() > 1) {
            keySize = Ints.tryParse(opensslAlgorithm.get(1));
            if (opensslAlgorithm.size() > 2) {
                mode = opensslAlgorithm.get(2);
                if (keySize == null) {
                    algorithm = opensslAlgorithm.get(1).startsWith("EDE") ? "DESede" : algorithm;
                }
            } else if (keySize == null) {
                mode = opensslAlgorithm.get(1);
            }
        }
        if (algorithm.startsWith("AES") && algorithm.length() > 3) {
            algorithm = "AES";
            keySize = algorithm.startsWith("AES192") ? 192 : (algorithm.startsWith("AES256") ? 256 : 128);
        } else if (algorithm.startsWith("DES2")) {
            algorithm = "DESede";
        } else if (algorithm.startsWith("DES3")) {
            algorithm = "DESede";
        }
        if (keySize == null) {
            keySize = "DESede".equals(algorithm) ? 192 : ("DES".equals(algorithm) ? 64 : 128);
        }
        if ("CFB".equals(mode) || "OFB".equals(mode)) {
            padding = "NoPadding";
        }
        if ("RC4".equals(algorithm)) {
            padding = null;
            mode = null;
        }
        byte[] secret = new byte[keySize / 8];
        byte[] encodedPassword = new String(password).getBytes(StandardCharsets.ISO_8859_1);
        HashFunction md5 = Hashing.md5();
        Hasher hasher = md5.newHasher();
        for (int pos = 0; pos < secret.length; pos += len) {
            hasher.putBytes(encodedPassword);
            if (iv != null) {
                hasher.putBytes(iv, 0, 8);
            }
            byte[] hash = hasher.hash().asBytes();
            len = Math.min(secret.length - pos, hash.length);
            System.arraycopy(hash, 0, secret, pos, len);
            hasher = md5.newHasher();
            hasher.putBytes(hash);
        }
        String transformation = Joiner.on('/').skipNulls().join(algorithm, mode, padding);
        SecretKeySpec key = new SecretKeySpec(secret, algorithm);
        IvParameterSpec params = null;
        if (!"ECB".equals(mode)) {
            params = new IvParameterSpec(iv);
        }
        if (keySize > Cipher.getMaxAllowedKeyLength(transformation)) {
            throw new InvalidKeyException("Illegal key size " + keySize + " for " + algorithm + " (consider unlimited strength cryptography policy)");
        }
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, (Key)key, params);
        return cipher;
    }

    public static class KeyPairStoreSpi
    extends KeyStoreSpi {
        private String alias;
        private byte[] privateKeyMaterial;
        private Certificate[] certificateChain;
        private Date creationDate;

        @Override
        public void engineLoad(KeyStore.LoadStoreParameter param2) throws IOException, NoSuchAlgorithmException, CertificateException {
            Certificate[] resultCertificateChain;
            byte[] resultPrivateKeyMaterial;
            KeyPairStoreLoadStoreParameter simpleParam;
            if (param2 instanceof KeyPairStoreLoadStoreParameter) {
                simpleParam = (KeyPairStoreLoadStoreParameter)param2;
                KeyPairStore.checkPrivateKeyPermissions(simpleParam.getKeyPath());
                resultPrivateKeyMaterial = Files.readAllBytes(simpleParam.getKeyPath());
                if (simpleParam.getProtectionParameter() instanceof KeyStore.PasswordProtection) {
                    try {
                        KeyPairStore.keySpec(resultPrivateKeyMaterial, ((KeyStore.PasswordProtection)simpleParam.getProtectionParameter()).getPassword());
                    }
                    catch (UnrecoverableKeyException e) {
                        if (Objects.equals(e.getMessage(), "bad password")) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try (InputStream in = Files.newInputStream(simpleParam.getCertificatePath(), new OpenOption[0]);){
                    Collection<? extends Certificate> certificates = CertificateFactory.getInstance("X509").generateCertificates(in);
                    if (certificates.isEmpty()) {
                        throw new CertificateException("invalid zero-length certificate chain");
                    }
                    if (certificates.iterator().next() instanceof X509Certificate) {
                        resultCertificateChain = certificates.toArray(new X509Certificate[certificates.size()]);
                    }
                    resultCertificateChain = certificates.toArray(new Certificate[certificates.size()]);
                }
            } else {
                throw new UnsupportedOperationException("unsupported load/store parameter: " + param2);
            }
            this.alias = simpleParam.getAlias();
            this.privateKeyMaterial = resultPrivateKeyMaterial;
            this.certificateChain = resultCertificateChain;
            this.creationDate = new Date();
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            if (Objects.equals(this.alias, alias)) {
                try {
                    KeySpec keySpec = KeyPairStore.keySpec(this.privateKeyMaterial, password);
                    String algorithm = KeyPairStore.algorithm(keySpec);
                    return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw (UnrecoverableKeyException)new UnrecoverableKeyException("failed to load key specification").initCause(e);
                }
            }
            return null;
        }

        @Override
        public Certificate[] engineGetCertificateChain(String alias) {
            return Objects.equals(this.alias, alias) ? (Certificate[])this.certificateChain.clone() : null;
        }

        @Override
        public Certificate engineGetCertificate(String alias) {
            return Objects.equals(this.alias, alias) ? this.certificateChain[0] : null;
        }

        @Override
        public Date engineGetCreationDate(String alias) {
            return Objects.equals(this.alias, alias) ? this.creationDate : null;
        }

        @Override
        public Enumeration<String> engineAliases() {
            return Collections.enumeration(Collections.singleton(this.alias));
        }

        @Override
        public boolean engineContainsAlias(String alias) {
            return Objects.equals(this.alias, alias);
        }

        @Override
        public int engineSize() {
            return 1;
        }

        @Override
        public boolean engineIsKeyEntry(String alias) {
            return Objects.equals(this.alias, alias);
        }

        @Override
        public boolean engineIsCertificateEntry(String alias) {
            return false;
        }

        @Override
        public String engineGetCertificateAlias(Certificate cert) {
            return Objects.equals(cert, this.certificateChain[0]) ? this.alias : null;
        }

        @Override
        public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
            throw new UnsupportedOperationException("single stream load is not supported");
        }

        @Override
        public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
            throw new UnsupportedOperationException("key store cannot be stored");
        }

        @Override
        public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
            throw new UnsupportedOperationException("key store is read only");
        }

        @Override
        public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
            throw new UnsupportedOperationException("key store is read only");
        }

        @Override
        public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
            throw new UnsupportedOperationException("key store is read only");
        }

        @Override
        public void engineDeleteEntry(String alias) throws KeyStoreException {
            throw new UnsupportedOperationException("key store is read only");
        }
    }

    private static final class KeyPairStoreLoadStoreParameter
    implements KeyStore.LoadStoreParameter {
        private final String alias;
        private final Path keyPath;
        private final Path certificatePath;
        private final KeyStore.PasswordProtection passwordProtection;

        private KeyPairStoreLoadStoreParameter(String alias, Path keyPath, Path certificatePath, KeyStore.PasswordProtection passwordProtection) {
            this.alias = Objects.requireNonNull(alias);
            this.keyPath = Objects.requireNonNull(keyPath);
            this.certificatePath = Objects.requireNonNull(certificatePath);
            this.passwordProtection = Objects.requireNonNull(passwordProtection);
        }

        public String getAlias() {
            return this.alias;
        }

        public Path getKeyPath() {
            return this.keyPath;
        }

        public Path getCertificatePath() {
            return this.certificatePath;
        }

        @Override
        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.passwordProtection;
        }
    }

    private static final class KeyPairStoreProvider
    extends Provider {
        private static final long serialVersionUID = 7920020778906707545L;

        private KeyPairStoreProvider() {
            super("Key Pair Key Store", 0.0, "");
            this.putService(new Provider.Service(this, "KeyStore", "keypair", KeyPairStoreSpi.class.getName(), null, null));
        }
    }

    public static final class Builder
    extends KeyStore.Builder {
        private final String alias;
        private final Path keyFile;
        private final Path certificateFile;
        private final KeyStore.ProtectionParameter protection;
        private KeyStore keyStore;
        private Throwable oldException;
        private KeyStore.PasswordProtection privateKeyPassword;

        private Builder(String alias, Path keyFile, Path certificateFile, KeyStore.ProtectionParameter protection) {
            this.alias = Objects.requireNonNull(alias);
            this.keyFile = Objects.requireNonNull(keyFile);
            this.certificateFile = Objects.requireNonNull(certificateFile);
            this.protection = Objects.requireNonNull(protection);
        }

        public static Builder newInstance(String alias, Path keyFile, Path certificateFile, KeyStore.ProtectionParameter protection) {
            return new Builder(alias, keyFile, certificateFile, protection);
        }

        @Override
        public synchronized KeyStore getKeyStore() throws KeyStoreException {
            int retryCount;
            if (this.keyStore != null) {
                return this.keyStore;
            }
            if (this.oldException != null) {
                throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
            }
            int n = retryCount = this.protection instanceof KeyStore.CallbackHandlerProtection ? 3 : 1;
            while (retryCount > 0) {
                try {
                    this.privateKeyPassword = this.privateKeyPassword(this.protection);
                    KeyStore resultKeyStore = KeyStore.getInstance("keypair", new KeyPairStoreProvider());
                    resultKeyStore.load(new KeyPairStoreLoadStoreParameter(this.alias, this.keyFile, this.certificateFile, this.privateKeyPassword));
                    this.keyStore = resultKeyStore;
                    return resultKeyStore;
                }
                catch (IOException | RuntimeException | KeyStoreException | NoSuchAlgorithmException | CertificateException | UnsupportedCallbackException e) {
                    this.oldException = e;
                    if (e instanceof IOException && e.getCause() instanceof UnrecoverableKeyException) {
                        --retryCount;
                        continue;
                    }
                    if (!(e instanceof KeyStoreException)) break;
                    throw (KeyStoreException)e;
                }
            }
            throw new KeyStoreException("KeyStore instantiation failed", this.oldException);
        }

        @Override
        @Nullable
        public KeyStore.ProtectionParameter getProtectionParameter(String alias) throws KeyStoreException {
            Objects.requireNonNull(alias);
            Preconditions.checkState(this.keyStore != null);
            return this.alias.equals(alias) ? this.privateKeyPassword : null;
        }

        private KeyStore.PasswordProtection privateKeyPassword(KeyStore.ProtectionParameter protection) throws KeyStoreException, UnsupportedCallbackException, IOException {
            if (protection instanceof KeyStore.PasswordProtection) {
                return (KeyStore.PasswordProtection)protection;
            }
            if (protection instanceof KeyStore.CallbackHandlerProtection) {
                PasswordCallback callback = new PasswordCallback("Password for key " + this.keyFile.getFileName(), false);
                try {
                    ((KeyStore.CallbackHandlerProtection)protection).getCallbackHandler().handle(new Callback[]{callback});
                    char[] password = callback.getPassword();
                    if (password != null) {
                        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(password);
                        return passwordProtection;
                    }
                    throw new KeyStoreException("No password provided");
                }
                finally {
                    callback.clearPassword();
                }
            }
            throw new IllegalArgumentException("Protection must be PasswordProtection or CallbackHandlerProtection");
        }
    }
}

