/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import javax.annotation.Nullable;

public final class ExtraKeyStores {
    @Nullable
    public static String guessKeyStoreAlgorithm(Path path) throws IOException {
        try (SeekableByteChannel c = Files.newByteChannel(path, new OpenOption[0]);){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            if (c.read(buffer) == buffer.capacity()) {
                buffer.flip();
                switch (buffer.getInt()) {
                    case -17957139: {
                        String string = "jks";
                        return string;
                    }
                    case -825307442: {
                        String string = "jceks";
                        return string;
                    }
                }
                if (buffer.get(buffer.position() - 4) == 48) {
                    String string = "pkcs12";
                    return string;
                }
            }
        }
        return null;
    }

    public static KeyStore.PasswordProtection getOnlyKeyProtection(KeyStore.Builder keyStoreBuilder) throws KeyStoreException {
        KeyStore.PasswordProtection result = null;
        KeyStore keyStore = keyStoreBuilder.getKeyStore();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            KeyStore.ProtectionParameter protection = keyStoreBuilder.getProtectionParameter(alias);
            if (protection instanceof KeyStore.PasswordProtection) {
                if (result != null) {
                    throw new IllegalStateException("KeyStore contains multiple key entries");
                }
                result = (KeyStore.PasswordProtection)protection;
                continue;
            }
            throw new IllegalStateException("KeyStore did not return password protection");
        }
        if (result != null) {
            return result;
        }
        throw new KeyStoreException("No key entry found");
    }

    private ExtraKeyStores() {
        assert (false);
    }
}

