/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.blackducksoftware.common.io.HeapChannel;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class HeapInputStream
extends ByteArrayInputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int offset;

    public HeapInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public HeapInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.offset = offset;
    }

    public HeapInputStream(ByteBuffer buf) {
        super(EMPTY_BYTE_ARRAY);
        if (!buf.hasArray()) {
            throw new IllegalArgumentException("buffer must be backed by an array");
        }
        this.buf = buf.array();
        this.pos = this.offset = buf.arrayOffset() + buf.position();
        this.count = buf.arrayOffset() + buf.limit();
    }

    public HeapChannel getChannel() {
        try {
            HeapChannel heapChannel = new HeapChannel(this.buf, this.offset, this.count);
            return heapChannel.position(this.pos - this.offset);
        }
        catch (ClosedChannelException e) {
            throw new IllegalStateException(e);
        }
    }

    public static HeapInputStream empty() {
        return new HeapInputStream(EMPTY_BYTE_ARRAY);
    }
}

