/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class ExtraIO {
    @VisibleForTesting
    static void joinOnIdleInputStream(InputStream in) throws InterruptedException {
        if (in instanceof OnIdleInputStream) {
            ((OnIdleInputStream)in).monitor.join();
        }
    }

    public static PrintWriter newPrintWriter(OutputStream out, Charset cs) {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, cs)));
    }

    public static InputStream buffer(InputStream in) {
        Objects.requireNonNull(in);
        if (in instanceof BufferedInputStream || in instanceof ByteArrayInputStream) {
            return in;
        }
        return new BufferedInputStream(in);
    }

    public static Reader buffer(Reader reader) {
        Objects.requireNonNull(reader);
        if (reader instanceof BufferedReader || reader instanceof CharArrayReader || reader instanceof StringReader) {
            return reader;
        }
        return new BufferedReader(reader);
    }

    public static OutputStream buffer(OutputStream out) {
        Objects.requireNonNull(out);
        if (out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream || out == ByteStreams.nullOutputStream()) {
            return out;
        }
        return new BufferedOutputStream(out);
    }

    public static Writer buffer(Writer writer) {
        Objects.requireNonNull(writer);
        if (writer instanceof BufferedWriter || writer instanceof CharArrayWriter || writer instanceof StringWriter) {
            return writer;
        }
        return new BufferedWriter(writer);
    }

    public static void closeUnchecked(Closeable c) throws UncheckedIOException {
        try {
            c.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream ignoreClose(InputStream in) {
        return new UnclosableInputStream(Objects.requireNonNull(in));
    }

    public static OutputStream ignoreClose(OutputStream out) {
        return new UnclosableOutputStream(Objects.requireNonNull(out));
    }

    public static InputStream onIdle(InputStream in, long idleTimeout, TimeUnit unit, Runnable callback) {
        return new OnIdleInputStream(in, idleTimeout, unit, callback);
    }

    private ExtraIO() {
        assert (false);
    }

    private static final class OnIdleInputStream
    extends FilterInputStream {
        private final Thread monitor;

        private OnIdleInputStream(InputStream in, final long idleTimeout, final TimeUnit unit, final Runnable callback) {
            super(Objects.requireNonNull(in));
            Preconditions.checkArgument(idleTimeout > 0L);
            Objects.requireNonNull(unit);
            Objects.requireNonNull(callback);
            this.monitor = new Thread("OnIdleInputStream-" + System.identityHashCode(in)){

                @Override
                public void run() {
                    try {
                        unit.sleep(idleTimeout);
                        callback.run();
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            };
            this.monitor.setDaemon(true);
            this.monitor.start();
        }

        @Override
        public int read() throws IOException {
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.monitor.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.monitor.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            try {
                long l = super.skip(n);
                return l;
            }
            finally {
                this.monitor.interrupt();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.monitor.interrupt();
            }
        }
    }

    private static final class UnclosableOutputStream
    extends FilterOutputStream {
        private UnclosableOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() {
        }
    }

    private static final class UnclosableInputStream
    extends FilterInputStream {
        private UnclosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

