/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.blackducksoftware.common.io.ByteUnit;

public enum BinaryByteUnit implements ByteUnit
{
    BYTES{

        @Override
        public long toBytes(long c) {
            return c;
        }

        @Override
        public long toKibibytes(long c) {
            return c / 1024L;
        }

        @Override
        public long toMebibytes(long c) {
            return c / 0x100000L;
        }

        @Override
        public long toGibibytes(long c) {
            return c / 0x40000000L;
        }

        @Override
        public long toTebibytes(long c) {
            return c / 0x10000000000L;
        }

        @Override
        public long toPebibytes(long c) {
            return c / 0x4000000000000L;
        }

        @Override
        public long toExbibytes(long c) {
            return c / 0x1000000000000000L;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toBytes(c);
        }
    }
    ,
    KIBIBYTES{

        @Override
        public long toBytes(long c) {
            return BinaryByteUnit.x(c, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKibibytes(long c) {
            return c;
        }

        @Override
        public long toMebibytes(long c) {
            return c / 1024L;
        }

        @Override
        public long toGibibytes(long c) {
            return c / 0x100000L;
        }

        @Override
        public long toTebibytes(long c) {
            return c / 0x40000000L;
        }

        @Override
        public long toPebibytes(long c) {
            return c / 0x10000000000L;
        }

        @Override
        public long toExbibytes(long c) {
            return c / 0x4000000000000L;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toKibibytes(c);
        }
    }
    ,
    MEBIBYTES{

        @Override
        public long toBytes(long c) {
            return BinaryByteUnit.x(c, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKibibytes(long c) {
            return BinaryByteUnit.x(c, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMebibytes(long c) {
            return c;
        }

        @Override
        public long toGibibytes(long c) {
            return c / 1024L;
        }

        @Override
        public long toTebibytes(long c) {
            return c / 0x100000L;
        }

        @Override
        public long toPebibytes(long c) {
            return c / 0x40000000L;
        }

        @Override
        public long toExbibytes(long c) {
            return c / 0x10000000000L;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toMebibytes(c);
        }
    }
    ,
    GIBIBYTES{

        @Override
        public long toBytes(long c) {
            return BinaryByteUnit.x(c, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKibibytes(long c) {
            return BinaryByteUnit.x(c, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMebibytes(long c) {
            return BinaryByteUnit.x(c, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGibibytes(long c) {
            return c;
        }

        @Override
        public long toTebibytes(long c) {
            return c / 1024L;
        }

        @Override
        public long toPebibytes(long c) {
            return c / 0x100000L;
        }

        @Override
        public long toExbibytes(long c) {
            return c / 0x40000000L;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toGibibytes(c);
        }
    }
    ,
    TEBIBYTES{

        @Override
        public long toBytes(long c) {
            return BinaryByteUnit.x(c, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKibibytes(long c) {
            return BinaryByteUnit.x(c, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMebibytes(long c) {
            return BinaryByteUnit.x(c, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGibibytes(long c) {
            return BinaryByteUnit.x(c, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTebibytes(long c) {
            return c;
        }

        @Override
        public long toPebibytes(long c) {
            return c / 1024L;
        }

        @Override
        public long toExbibytes(long c) {
            return c / 0x100000L;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toTebibytes(c);
        }
    }
    ,
    PEBIBYTES{

        @Override
        public long toBytes(long c) {
            return BinaryByteUnit.x(c, 0x4000000000000L, 8191L);
        }

        @Override
        public long toKibibytes(long c) {
            return BinaryByteUnit.x(c, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toMebibytes(long c) {
            return BinaryByteUnit.x(c, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGibibytes(long c) {
            return BinaryByteUnit.x(c, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTebibytes(long c) {
            return BinaryByteUnit.x(c, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPebibytes(long c) {
            return c;
        }

        @Override
        public long toExbibytes(long c) {
            return c / 1024L;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toPebibytes(c);
        }
    }
    ,
    EXBIBYTES{

        @Override
        public long toBytes(long c) {
            return BinaryByteUnit.x(c, 0x1000000000000000L, 7L);
        }

        @Override
        public long toKibibytes(long c) {
            return BinaryByteUnit.x(c, 0x4000000000000L, 8191L);
        }

        @Override
        public long toMebibytes(long c) {
            return BinaryByteUnit.x(c, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toGibibytes(long c) {
            return BinaryByteUnit.x(c, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toTebibytes(long c) {
            return BinaryByteUnit.x(c, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toPebibytes(long c) {
            return BinaryByteUnit.x(c, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toExbibytes(long c) {
            return c;
        }

        @Override
        public long convert(long c, BinaryByteUnit u) {
            return u.toExbibytes(c);
        }
    };

    private static final long C0 = 1L;
    private static final long C1 = 1024L;
    private static final long C2 = 0x100000L;
    private static final long C3 = 0x40000000L;
    private static final long C4 = 0x10000000000L;
    private static final long C5 = 0x4000000000000L;
    private static final long C6 = 0x1000000000000000L;

    private static long x(long d, long m3, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m3;
    }

    public abstract long toKibibytes(long var1);

    public abstract long toMebibytes(long var1);

    public abstract long toGibibytes(long var1);

    public abstract long toTebibytes(long var1);

    public abstract long toPebibytes(long var1);

    public abstract long toExbibytes(long var1);

    public abstract long convert(long var1, BinaryByteUnit var3);
}

