/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.i18n;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class BundleControl
extends ResourceBundle.Control {
    private final Charset defaultEncoding;

    @VisibleForTesting
    protected BundleControl(Charset defaultEncoding) {
        this.defaultEncoding = Objects.requireNonNull(defaultEncoding);
    }

    public static BundleControl create() {
        return new BundleControl(StandardCharsets.UTF_8);
    }

    public static BundleControl createDevelopmentControl() {
        return new BundleControl(StandardCharsets.UTF_8){

            @Override
            public long getTimeToLive(String baseName, Locale locale) {
                Objects.requireNonNull(baseName);
                Objects.requireNonNull(locale);
                return -1L;
            }
        };
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        ResourceBundle result = null;
        if (FORMAT_PROPERTIES.contains(format)) {
            URL url = loader.getResource(this.toResourceName(this.toBundleName(baseName, locale), "properties"));
            if (url != null) {
                URLConnection connection = url.openConnection();
                connection.setUseCaches(!reload);
                Charset encoding = Optional.ofNullable(connection.getContentEncoding()).map(Charset::forName).orElse(this.defaultEncoding);
                try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), encoding);){
                    result = new PropertyResourceBundle(reader);
                }
            }
        } else {
            result = super.newBundle(baseName, locale, format, loader, reload);
        }
        return result;
    }
}

