/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ForwardingExecutorService
implements ExecutorService {
    protected ForwardingExecutorService() {
    }

    protected abstract ExecutorService delegate();

    protected Runnable wrap(Runnable task) {
        return task;
    }

    protected <V> Callable<V> wrap(Callable<V> task) {
        return task;
    }

    protected <V> Collection<? extends Callable<V>> wrapAll(Collection<? extends Callable<V>> tasks) {
        ArrayList<Callable<V>> wrappedTasks = new ArrayList<Callable<V>>(tasks.size());
        for (Callable<V> task : tasks) {
            wrappedTasks.add(this.wrap(task));
        }
        return wrappedTasks;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate().execute(this.wrap(command));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate().submit(this.wrap(task));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate().submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate().submit(this.wrap(task), result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate().invokeAll(this.wrapAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate().invokeAll(this.wrapAll(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate().invokeAny(this.wrapAll(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate().invokeAny(this.wrapAll(tasks), timeout, unit);
    }

    @Override
    public void shutdown() {
        this.delegate().shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate().awaitTermination(timeout, unit);
    }

    public static abstract class SimpleForwardingExecutorService
    extends ForwardingExecutorService {
        private final ExecutorService delegate;

        protected SimpleForwardingExecutorService(ExecutorService delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        protected final ExecutorService delegate() {
            return this.delegate;
        }
    }
}

