/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

public class ExtraUUIDs {
    private static final UUID NIL;
    private static final UUID NAME_SPACE_DNS;
    private static final UUID NAME_SPACE_URL;
    private static final UUID NAME_SPACE_OID;
    private static final UUID NAME_SPACE_X500;
    private static final byte[] ASCII_HEX_DIGITS;

    public static UUID nilUUID() {
        return NIL;
    }

    public static String toUriString(UUID uuid) {
        return "urn:uuid:" + uuid;
    }

    public static URI toUri(UUID uuid) {
        return URI.create(ExtraUUIDs.toUriString(uuid));
    }

    public static UUID fromUriString(CharSequence uri) {
        Preconditions.checkArgument(uri.length() == 45, "UUID URN should be exactly 45 characters (was %s): %s", uri.length(), (Object)uri);
        Preconditions.checkArgument(Ascii.equalsIgnoreCase("urn:uuid:", uri.subSequence(0, 9)), "expected UUID URN scheme: %s", (Object)uri);
        return ExtraUUIDs.fromString(uri.subSequence(9, 45));
    }

    public static UUID fromUri(URI uri) {
        Preconditions.checkArgument(Ascii.equalsIgnoreCase(uri.getScheme(), "urn"), "expected 'urn' scheme: %s", (Object)uri);
        String ssp = uri.getSchemeSpecificPart();
        Preconditions.checkArgument(ssp != null && Ascii.equalsIgnoreCase(ssp.substring(0, 5), "uuid:"), "expected 'uuid' namespace: %s ", (Object)uri);
        return ExtraUUIDs.fromString(ssp.substring(5));
    }

    public static ByteBuffer putUUID(ByteBuffer bb, UUID uuid) {
        return bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
    }

    public static UUID fromString(CharSequence input) {
        Preconditions.checkArgument(input.length() == 36, "Invalid UUID string: %s", (Object)input);
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        for (int i = 0; i < 36; ++i) {
            int value;
            char c = input.charAt(i);
            int n = value = c < '\u0080' ? ASCII_HEX_DIGITS[c] : -1;
            if (value >= 0) {
                if (i < 19) {
                    mostSigBits = mostSigBits * 16L - (long)value;
                    continue;
                }
                leastSigBits = leastSigBits * 16L - (long)value;
                continue;
            }
            if (value == -2) {
                Preconditions.checkArgument(i == 8 || i == 13 || i == 18 || i == 23, "Invalid UUID string: %s", (Object)input);
                continue;
            }
            throw new NumberFormatException("Invalid UUID string: " + input);
        }
        return new UUID(-mostSigBits, -leastSigBits);
    }

    public static UUID nameUUIDFromBytes(UUID nameSpaceId, byte[] name) {
        byte[] nameBytes = new byte[16 + name.length];
        ExtraUUIDs.putUUID(ByteBuffer.wrap(nameBytes), nameSpaceId).put(name);
        return UUID.nameUUIDFromBytes(nameBytes);
    }

    public static UUID nameUUIDFromUnencodedChars(UUID nameSpaceId, CharSequence name) {
        int len = name.length();
        byte[] nameBytes = new byte[16 + len * 2];
        ByteBuffer buf = ExtraUUIDs.putUUID(ByteBuffer.wrap(nameBytes), nameSpaceId);
        for (int i = 0; i < len; ++i) {
            buf.putChar(name.charAt(i));
        }
        return UUID.nameUUIDFromBytes(nameBytes);
    }

    public static UUID nameUUIDFromBytes(UUID nameSpaceId, ByteBuffer name) {
        byte[] nameBytes = new byte[16 + name.remaining()];
        ExtraUUIDs.putUUID(ByteBuffer.wrap(nameBytes), nameSpaceId).put(name);
        return UUID.nameUUIDFromBytes(nameBytes);
    }

    public static UUID nameUUIDFromDns(String fullyQualifiedDomainName) {
        return ExtraUUIDs.nameUUIDFromBytes(NAME_SPACE_DNS, StandardCharsets.UTF_8.encode(fullyQualifiedDomainName));
    }

    public static UUID nameUUIDFromUrl(String url) {
        return ExtraUUIDs.nameUUIDFromBytes(NAME_SPACE_URL, StandardCharsets.UTF_8.encode(url));
    }

    public static UUID nameUUIDFromOid(String oid) {
        return ExtraUUIDs.nameUUIDFromBytes(NAME_SPACE_OID, StandardCharsets.US_ASCII.encode(oid));
    }

    public static UUID nameUUIDFromX500(String dn) {
        return ExtraUUIDs.nameUUIDFromBytes(NAME_SPACE_X500, StandardCharsets.UTF_8.encode(dn));
    }

    public static UUID nameUUIDFromX500(byte[] dn) {
        return ExtraUUIDs.nameUUIDFromBytes(NAME_SPACE_X500, dn);
    }

    private ExtraUUIDs() {
        assert (false);
    }

    static {
        int i;
        NIL = new UUID(0L, 0L);
        NAME_SPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
        NAME_SPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
        NAME_SPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
        NAME_SPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");
        ASCII_HEX_DIGITS = new byte[128];
        Arrays.fill(ASCII_HEX_DIGITS, (byte)-1);
        ExtraUUIDs.ASCII_HEX_DIGITS[45] = -2;
        for (i = 0; i < 10; ++i) {
            ExtraUUIDs.ASCII_HEX_DIGITS[48 + i] = (byte)i;
        }
        for (i = 0; i < 6; ++i) {
            ExtraUUIDs.ASCII_HEX_DIGITS[65 + i] = (byte)(10 + i);
            ExtraUUIDs.ASCII_HEX_DIGITS[97 + i] = (byte)(10 + i);
        }
    }
}

