/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExtraThrowables {
    public static Supplier<IllegalArgumentException> illegalArgument(String errorMessageTemplate, Object ... errorMessageArgs) {
        return () -> new IllegalArgumentException(ExtraThrowables.format(errorMessageTemplate, errorMessageArgs));
    }

    public static Supplier<IllegalStateException> illegalState(String errorMessageTemplate, Object ... errorMessageArgs) {
        return () -> new IllegalStateException(ExtraThrowables.format(errorMessageTemplate, errorMessageArgs));
    }

    public static Supplier<NoSuchElementException> noSuchElement(String errorMessageTemplate, Object ... errorMessageArgs) {
        return () -> new NoSuchElementException(ExtraThrowables.format(errorMessageTemplate, errorMessageArgs));
    }

    public static Supplier<NullPointerException> nullPointer(String errorMessageTemplate, Object ... errorMessageArgs) {
        return () -> new NullPointerException(ExtraThrowables.format(errorMessageTemplate, errorMessageArgs));
    }

    public static <T extends Throwable> T addSuppressed(T throwable, Throwable suppressed) {
        throwable.addSuppressed(suppressed);
        return throwable;
    }

    public static <T extends Throwable> T initCause(T throwable, Throwable cause) {
        throwable.initCause(cause);
        return throwable;
    }

    public static <T extends Throwable> T fillInStackTrace(T throwable) {
        throwable.fillInStackTrace();
        return throwable;
    }

    public static void check(boolean condition, Supplier<? extends RuntimeException> failure) {
        if (!condition) {
            throw failure.get();
        }
    }

    public static void check(boolean condition, Function<String, ? extends RuntimeException> failure, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!condition) {
            throw failure.apply(ExtraThrowables.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    private static String format(String template, Object ... args) {
        return String.format(template, args);
    }

    private ExtraThrowables() {
        assert (false);
    }
}

