/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import com.google.common.base.CharMatcher;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ExtraStrings {
    public static boolean isNotEmpty(CharSequence value) {
        return value.length() > 0;
    }

    public static Optional<String> ofEmpty(@Nullable CharSequence value) {
        return Optional.ofNullable(value).filter(ExtraStrings::isNotEmpty).map(CharSequence::toString);
    }

    public static Optional<String> ofBlank(@Nullable CharSequence value) {
        return Optional.ofNullable(value).filter(CharMatcher.whitespace().negate()::matchesAnyOf).map(CharSequence::toString);
    }

    @Nullable
    public static String ensurePrefix(CharSequence prefix, @Nullable CharSequence value) {
        Objects.requireNonNull(prefix);
        if (value == null) {
            return null;
        }
        if (ExtraStrings.startsWith(value, prefix, 0)) {
            return value.toString();
        }
        return new StringBuilder(prefix.length() + value.length()).append(prefix).append(value).toString();
    }

    @Nullable
    public static String ensureSuffix(@Nullable CharSequence value, CharSequence suffix) {
        Objects.requireNonNull(suffix);
        if (value == null) {
            return null;
        }
        if (ExtraStrings.startsWith(value, suffix, value.length() - suffix.length())) {
            return value.toString();
        }
        return new StringBuilder(value.length() + suffix.length()).append(value).append(suffix).toString();
    }

    public static String ensureDelimiter(@Nullable CharSequence start, CharSequence delimiter, @Nullable CharSequence end) {
        Objects.requireNonNull(delimiter);
        if (start == null && end == null) {
            return delimiter.toString();
        }
        boolean delimit = start == null || !ExtraStrings.startsWith(start, delimiter, start.length() - delimiter.length());
        int endOffset = 0;
        if (end != null && ExtraStrings.startsWith(end, delimiter, 0)) {
            if (delimit) {
                delimit = false;
            } else {
                endOffset = delimiter.length();
            }
        }
        int len = (start != null ? start.length() : 0) + (delimit ? delimiter.length() : 0) + (end != null ? end.length() - endOffset : 0);
        StringBuilder result = new StringBuilder(len);
        if (start != null) {
            result.append(start);
        }
        if (delimit) {
            result.append(delimiter);
        }
        if (end != null) {
            result.append(end, endOffset, end.length());
        }
        return result.toString();
    }

    public static String ensureDelimiter(Iterable<?> parts, CharSequence delimiter) {
        StringJoiner joiner = new StringJoiner(delimiter);
        parts.forEach(o -> {
            if (o instanceof CharSequence) {
                joiner.add((CharSequence)o);
            } else {
                joiner.add(o.toString());
            }
        });
        return joiner.toString();
    }

    public static String padBoth(@Nullable CharSequence value, int minLength, char padChar) {
        int i;
        if (value == null) {
            char[] result = new char[minLength];
            Arrays.fill(result, padChar);
            return new String(result);
        }
        if (value.length() >= minLength) {
            return value.toString();
        }
        StringBuilder result = new StringBuilder(minLength);
        for (i = (int)Math.floor((double)(minLength - value.length()) / 2.0); i > 0; --i) {
            result.append(padChar);
        }
        result.append(value);
        for (i = result.length(); i < minLength; ++i) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static String truncateEnd(CharSequence value, int maxLength) {
        return value.length() > maxLength ? value.subSequence(0, maxLength).toString() : value.toString();
    }

    public static String truncateStart(CharSequence value, int maxLength) {
        return value.length() > maxLength ? value.subSequence(value.length() - maxLength, value.length()).toString() : value.toString();
    }

    public static String truncateMiddle(CharSequence value, int maxLength) {
        if (maxLength < 2) {
            throw new IllegalArgumentException("maxLength must be a least 2 (was " + maxLength + ")");
        }
        if (value.length() <= maxLength) {
            return value.toString();
        }
        StringBuilder result = new StringBuilder(maxLength);
        double split = (double)(maxLength - 2) / 2.0;
        result.append(value.subSequence(0, (int)Math.floor(split)));
        result.append('.').append('.');
        result.append(value.subSequence(value.length() - (int)Math.ceil(split), value.length()));
        return result.toString();
    }

    @Nullable
    public static String removePrefix(@Nullable CharSequence value, @Nullable CharSequence prefix) {
        if (value != null && prefix != null) {
            if (ExtraStrings.startsWith(value, prefix, 0)) {
                return value.subSequence(prefix.length(), value.length()).toString();
            }
            return value.toString();
        }
        return value != null ? value.toString() : null;
    }

    @Nullable
    public static String removeSuffix(@Nullable CharSequence value, @Nullable CharSequence suffix) {
        if (value != null && suffix != null) {
            int pos = value.length() - suffix.length();
            if (ExtraStrings.startsWith(value, suffix, pos)) {
                return value.subSequence(0, pos).toString();
            }
            return value.toString();
        }
        return value != null ? value.toString() : null;
    }

    @Nullable
    public static String beforeFirst(@Nullable CharSequence value, char c) {
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != c) continue;
                return value.subSequence(0, i).toString();
            }
            return value.toString();
        }
        return null;
    }

    @Nullable
    public static String beforeLast(@Nullable CharSequence value, char c) {
        if (value != null) {
            for (int i = value.length() - 1; i >= 0; --i) {
                if (value.charAt(i) != c) continue;
                return value.subSequence(0, i).toString();
            }
            return value.toString();
        }
        return null;
    }

    @Nullable
    public static String afterFirst(@Nullable CharSequence value, char c) {
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != c) continue;
                return value.subSequence(i + 1, value.length()).toString();
            }
            return "";
        }
        return null;
    }

    @Nullable
    public static String afterLast(@Nullable CharSequence value, char c) {
        if (value != null) {
            for (int i = value.length() - 1; i >= 0; --i) {
                if (value.charAt(i) != c) continue;
                return value.subSequence(i + 1, value.length()).toString();
            }
            return "";
        }
        return null;
    }

    @Nullable
    public static <R> R splitOnFirst(@Nullable CharSequence value, char c, BiFunction<String, String, R> joiner) {
        Objects.requireNonNull(joiner);
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != c) continue;
                return joiner.apply(value.subSequence(0, i).toString(), value.subSequence(i + 1, value.length()).toString());
            }
            return joiner.apply(value.toString(), "");
        }
        return null;
    }

    @Nullable
    public static <R> R splitOnLast(@Nullable CharSequence value, char c, BiFunction<String, String, R> joiner) {
        Objects.requireNonNull(joiner);
        if (value != null) {
            for (int i = value.length() - 1; i >= 0; --i) {
                if (value.charAt(i) != c) continue;
                return joiner.apply(value.subSequence(0, i).toString(), value.subSequence(i + 1, value.length()).toString());
            }
            return joiner.apply("", value.toString());
        }
        return null;
    }

    public static Stream<String> split(final @Nullable CharSequence value, final char delim) {
        if (value == null) {
            return Stream.empty();
        }
        class CharSplitterSpliterator
        extends Spliterators.AbstractSpliterator<String> {
            private int pos;

            public CharSplitterSpliterator() {
                super(Long.MAX_VALUE, 272);
            }

            @Override
            public boolean tryAdvance(Consumer<? super String> action) {
                int len = value.length();
                if (this.pos > len) {
                    return false;
                }
                for (int i = this.pos; i < len; ++i) {
                    if (value.charAt(i) != delim) continue;
                    action.accept(value.subSequence(this.pos, i).toString());
                    this.pos = i + 1;
                    return true;
                }
                action.accept(value.subSequence(this.pos, len).toString());
                this.pos = len + 1;
                return true;
            }
        }
        return StreamSupport.stream(new CharSplitterSpliterator(), false);
    }

    static boolean startsWith(CharSequence value, CharSequence prefix, int offset) {
        int o = prefix.length();
        int pi = 0;
        int vi = offset;
        if (offset < 0 || offset > value.length() - prefix.length()) {
            return false;
        }
        while (--o >= 0) {
            if (prefix.charAt(pi++) == value.charAt(vi++)) continue;
            return false;
        }
        return true;
    }

    private ExtraStrings() {
        assert (false);
    }
}

