/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ExtraObjects {
    public static <T> ToStringBuilder<T> toString(T self) {
        return new ToStringBuilder(self);
    }

    public static <T> ToStringBuilder<T> toString(String superToString, T self) {
        int pos = superToString.indexOf(123);
        if (pos < 0 || !superToString.endsWith("}")) {
            if (superToString.equals(self.getClass().getName() + '@' + Integer.toHexString(self.hashCode()))) {
                return new ToStringBuilder(self);
            }
            throw new IllegalArgumentException("invalid super toString: " + superToString);
        }
        ToStringBuilder builder = new ToStringBuilder(self);
        builder.builder().append(superToString, pos + 1, superToString.length() - 1);
        return builder;
    }

    public static <T> Function<Object, T> cast(Class<T> type) {
        Objects.requireNonNull(type);
        return obj -> type.isInstance(obj) ? type.cast(obj) : null;
    }

    private ExtraObjects() {
        assert (false);
    }

    public static final class ToStringBuilder<T> {
        private final T self;
        private StringBuilder value;

        private ToStringBuilder(T self) {
            this.self = Objects.requireNonNull(self);
        }

        public ToStringBuilder<T> add(String name, boolean value) {
            this.nameEquals(name).append(value);
            return this;
        }

        public ToStringBuilder<T> add(String name, char value) {
            this.nameEquals(name).append(value);
            return this;
        }

        public ToStringBuilder<T> add(String name, int value) {
            this.nameEquals(name).append(value);
            return this;
        }

        public ToStringBuilder<T> add(String name, long value) {
            this.nameEquals(name).append(value);
            return this;
        }

        public ToStringBuilder<T> add(String name, double value) {
            this.nameEquals(name).append(value);
            return this;
        }

        public ToStringBuilder<T> add(String name, float value) {
            this.nameEquals(name).append(value);
            return this;
        }

        public ToStringBuilder<T> add(String name, @Nullable Object value, @Nullable Object nullValue) {
            if (value != null && value.getClass().isArray()) {
                String arrayToString = Arrays.deepToString(new Object[]{value});
                this.nameEquals(name).append(arrayToString.substring(1, arrayToString.length() - 1));
            } else if (value != null || nullValue != null) {
                this.nameEquals(name).append(value != null ? value : nullValue);
            } else {
                Objects.requireNonNull(name);
            }
            return this;
        }

        public ToStringBuilder<T> add(String name, @Nullable Object value) {
            return this.add(name, value, null);
        }

        public ToStringBuilder<T> add(String name, Function<T, Object> accessor) {
            return this.add(name, accessor.apply(this.self));
        }

        public String toString() {
            StringBuilder result = this.value != null ? this.value : this.builder();
            this.value = null;
            return result.append('}').toString();
        }

        private StringBuilder nameEquals(String name) {
            Objects.requireNonNull(name);
            return this.builder().append(name).append('=');
        }

        private StringBuilder builder() {
            if (this.value != null) {
                return this.value.append(',').append(' ');
            }
            this.value = new StringBuilder(32).append(this.self.getClass().getSimpleName()).append('{');
            return this.value;
        }
    }
}

