/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExtraFunctions {
    public static <T, R> Function<T, R> nullSafe(final Function<T, R> f) {
        Objects.requireNonNull(f);
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return Optional.ofNullable(t).map(f).orElse(null);
            }

            @Override
            public <V> Function<V, R> compose(Function<? super V, ? extends T> before) {
                Objects.requireNonNull(before);
                return v -> Optional.ofNullable(v).map(before).map(f).orElse(null);
            }

            @Override
            public <V> Function<T, V> andThen(Function<? super R, ? extends V> after) {
                Objects.requireNonNull(after);
                return t -> Optional.ofNullable(t).map(f).map(after).orElse(null);
            }
        };
    }

    public static <T, U, R> Function<U, R> curry(@Nullable T t, BiFunction<T, U, R> f) {
        Objects.requireNonNull(f);
        return u -> f.apply(t, u);
    }

    public static <T, U, R> Function<T, R> curry(BiFunction<T, U, R> f, @Nullable U u) {
        Objects.requireNonNull(f);
        return t -> f.apply(t, u);
    }

    private ExtraFunctions() {
        assert (false);
    }
}

