/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import com.blackducksoftware.common.io.BinaryByteUnit;
import com.blackducksoftware.common.io.ByteUnit;
import com.blackducksoftware.common.io.DecimalByteUnit;
import java.time.Duration;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ExtraFormats {
    private static final String[] TIME_UNIT = new String[]{"ns", "\u03bcs", "ms", "s", "min", "h", "d"};
    private static final String[] BINARY_BYTE_UNIT = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
    private static final String[] DECIMAL_BYTE_UNIT = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    public static FormattableDuration print(Duration duration) {
        return new FormattableDuration(duration);
    }

    public static FormattableByteCount print(long count, ByteUnit unit) {
        if (unit instanceof BinaryByteUnit) {
            return new FormattableBinaryByteCount(unit.toBytes(count));
        }
        if (unit instanceof DecimalByteUnit) {
            return new FormattableDecimalByteCount(unit.toBytes(count));
        }
        return new FormattableByteCount(unit.toBytes(count));
    }

    public static FormattableObject print(Supplier<String> toString) {
        return new FormattableObject(toString);
    }

    private static String computeFormat(int flags, int width, int precision, String abbreviation) {
        if (width < 0 && precision < 0) {
            return new StringBuilder(5 + abbreviation.length()).append("%.4g ").append(abbreviation).toString();
        }
        StringBuilder formatBuilder = new StringBuilder(8).append("%");
        if (width > abbreviation.length() + 1) {
            formatBuilder.append(width - (1 + abbreviation.length()));
        }
        return formatBuilder.append('.').append(precision < 0 ? 4 : precision).append("g ").append(abbreviation).toString();
    }

    private static String computeFormat(int flags, int width, int precision) {
        if (width < 0 && precision < 0) {
            return "%s";
        }
        StringBuilder formatBuilder = new StringBuilder(8).append('%');
        if (width >= 0) {
            formatBuilder.append(width);
        }
        if (precision >= 0) {
            formatBuilder.append('.').append(precision);
        }
        return formatBuilder.append('s').toString();
    }

    private static BinaryByteUnit chooseBinaryByteUnit(long byteCount) {
        if (BinaryByteUnit.BYTES.toExbibytes(byteCount) > 0L) {
            return BinaryByteUnit.EXBIBYTES;
        }
        if (BinaryByteUnit.BYTES.toPebibytes(byteCount) > 0L) {
            return BinaryByteUnit.PEBIBYTES;
        }
        if (BinaryByteUnit.BYTES.toTebibytes(byteCount) > 0L) {
            return BinaryByteUnit.TEBIBYTES;
        }
        if (BinaryByteUnit.BYTES.toGibibytes(byteCount) > 0L) {
            return BinaryByteUnit.GIBIBYTES;
        }
        if (BinaryByteUnit.BYTES.toMebibytes(byteCount) > 0L) {
            return BinaryByteUnit.MEBIBYTES;
        }
        if (BinaryByteUnit.BYTES.toKibibytes(byteCount) > 0L) {
            return BinaryByteUnit.KIBIBYTES;
        }
        return BinaryByteUnit.BYTES;
    }

    private static DecimalByteUnit chooseDecimalByteUnit(long byteCount) {
        if (DecimalByteUnit.BYTES.toExabytes(byteCount) > 0L) {
            return DecimalByteUnit.EXABYTES;
        }
        if (DecimalByteUnit.BYTES.toPetabytes(byteCount) > 0L) {
            return DecimalByteUnit.PETABYTES;
        }
        if (DecimalByteUnit.BYTES.toTerabytes(byteCount) > 0L) {
            return DecimalByteUnit.TERABYTES;
        }
        if (DecimalByteUnit.BYTES.toGigabytes(byteCount) > 0L) {
            return DecimalByteUnit.GIGABYTES;
        }
        if (DecimalByteUnit.BYTES.toMegabytes(byteCount) > 0L) {
            return DecimalByteUnit.MEGABYTES;
        }
        if (DecimalByteUnit.BYTES.toKilobytes(byteCount) > 0L) {
            return DecimalByteUnit.KILOBYTES;
        }
        return DecimalByteUnit.BYTES;
    }

    private static TimeUnit chooseTimeUnit(long nanos) {
        if (TimeUnit.NANOSECONDS.toDays(nanos) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.NANOSECONDS.toHours(nanos) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.NANOSECONDS.toMinutes(nanos) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.NANOSECONDS.toSeconds(nanos) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.NANOSECONDS.toMillis(nanos) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.NANOSECONDS.toMicros(nanos) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    public static final class FormattableObject
    implements Formattable {
        private final Supplier<String> toString;

        private FormattableObject(Supplier<String> toString) {
            this.toString = Objects.requireNonNull(toString);
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            String value = this.toString.get();
            String format = ExtraFormats.computeFormat(flags, width, precision);
            formatter.format(format, value);
        }

        public String toString() {
            return this.toString.get();
        }
    }

    public static final class FormattableDuration
    implements Formattable {
        private final Duration duration;

        private FormattableDuration(Duration duration) {
            this.duration = Objects.requireNonNull(duration);
        }

        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            long nanos = this.duration.toNanos();
            TimeUnit unit = ExtraFormats.chooseTimeUnit(nanos);
            double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
            String format = ExtraFormats.computeFormat(flags, width, precision, TIME_UNIT[unit.ordinal()]);
            formatter.format(format, value);
        }

        public String toString() {
            Formatter formatter = new Formatter(new StringBuilder(10));
            this.formatTo(formatter, 0, -1, -1);
            return formatter.toString();
        }
    }

    private static final class FormattableDecimalByteCount
    extends FormattableByteCount {
        private FormattableDecimalByteCount(long byteCount) {
            super(byteCount);
        }

        @Override
        protected ByteUnit chooseByteUnit(long byteCount) {
            return ExtraFormats.chooseDecimalByteUnit(byteCount);
        }

        @Override
        protected String abbreviate(ByteUnit unit) {
            return DECIMAL_BYTE_UNIT[((DecimalByteUnit)unit).ordinal()];
        }
    }

    private static final class FormattableBinaryByteCount
    extends FormattableByteCount {
        private FormattableBinaryByteCount(long byteCount) {
            super(byteCount);
        }

        @Override
        protected ByteUnit chooseByteUnit(long byteCount) {
            return ExtraFormats.chooseBinaryByteUnit(byteCount);
        }

        @Override
        protected String abbreviate(ByteUnit unit) {
            return BINARY_BYTE_UNIT[((BinaryByteUnit)unit).ordinal()];
        }
    }

    public static class FormattableByteCount
    implements Formattable {
        private final long byteCount;

        private FormattableByteCount(long byteCount) {
            this.byteCount = byteCount;
        }

        public long getByteCount() {
            return this.byteCount;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            ByteUnit unit = this.chooseByteUnit(this.byteCount);
            double value = (double)this.byteCount / (double)unit.toBytes(1L);
            String format = ExtraFormats.computeFormat(flags, width, precision, this.abbreviate(unit));
            formatter.format(format, value);
        }

        public String toString() {
            Formatter formatter = new Formatter(new StringBuilder(10));
            this.formatTo(formatter, 0, -1, -1);
            return formatter.toString();
        }

        protected ByteUnit chooseByteUnit(long byteCount) {
            return c -> c;
        }

        protected String abbreviate(ByteUnit unit) {
            return "B";
        }
    }
}

