/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioContext;
import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.model.Dependency;
import com.blackducksoftware.bdio2.model.File;
import com.blackducksoftware.common.base.ExtraUUIDs;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Ascii;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

class LegacyUtilities {
    private static final int ESTIMATED_NODE_SIZE = 400;
    private static final ObjectMapper SCAN_CONTAINER_OBJECT_MAPPER = new ObjectMapper().registerModule(LegacyScanContainerModule.INSTANCE);
    private static final UUID LEGACY_EMITTER_NS = ExtraUUIDs.fromString("d4bb9cdd-d89c-3a42-af03-393e0be722e4");
    private static final UUID DEPENDENCY_IDENTIFIER_NS = ExtraUUIDs.fromString("24ac915b-3be8-4a7d-8840-11fe8e84b680");

    LegacyUtilities() {
    }

    public static ObjectMapper scanContainerObjectMapper() {
        return SCAN_CONTAINER_OBJECT_MAPPER;
    }

    public static int averageEntryNodeCount() {
        return 41943;
    }

    public static Stream<List<Map<String, Object>>> partitionNodes(BdioMetadata metadata, Stream<Map<String, Object>> nodes) {
        int maxSize = 0x1000000 - LegacyUtilities.estimateEntryOverhead(metadata);
        int averageSize = 41943;
        return StreamSupport.stream(LegacyUtilities.partition(nodes.spliterator(), averageSize, maxSize, LegacyUtilities::estimateSize), false);
    }

    public static int estimateSize(@Nullable Object obj) {
        if (obj == null) {
            return 4;
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString().length();
        }
        if (obj instanceof List) {
            int size = 2;
            for (Object item : (List)obj) {
                size += 1 + LegacyUtilities.estimateSize(item);
            }
            return size;
        }
        if (obj instanceof Map) {
            int size = 2;
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                size += 1 + LegacyUtilities.estimateSize(entry.getKey());
                size += 1 + LegacyUtilities.estimateSize(entry.getValue());
            }
            return size;
        }
        return 2 + (int)(1.1 * (double)obj.toString().length());
    }

    public static int estimateEntryOverhead(BdioMetadata metadata) {
        return 20 + LegacyUtilities.estimateSize(metadata.id());
    }

    public static void mergeDependency(Multimap<String, Dependency> dependencies, Dependency dependency) {
        BdioContext context = BdioContext.getDefault();
        String id = LegacyUtilities.dependencyIdentifier(context, dependency);
        dependency.put("@id", (Object)id);
        for (Dependency dep : dependencies.get(id)) {
            if (!dep.keySet().equals(dependency.keySet())) continue;
            if (dep.containsKey(Bdio.ObjectProperty.declaredBy.toString())) {
                context.getFieldValue(Bdio.ObjectProperty.declaredBy.toString(), dependency).map(Object::toString).map(File::new).forEach(dep::declaredBy);
                return;
            }
            if (!dep.containsKey(Bdio.ObjectProperty.evidence.toString())) continue;
            context.getFieldValue(Bdio.ObjectProperty.evidence.toString(), dependency).map(Object::toString).map(File::new).forEach(dep::evidence);
            return;
        }
        dependencies.put(id, dependency);
    }

    public static String guessScheme(@Nullable String filename) {
        if (filename != null) {
            char c;
            int end;
            int start = end = filename.length();
            while (start > 0 && (c = filename.charAt(--start)) != '/') {
                if (c != '.') continue;
                switch (Ascii.toLowerCase(filename.substring(start + 1, end))) {
                    case "zip": 
                    case "bz": 
                    case "z": 
                    case "nupg": 
                    case "xpi": 
                    case "egg": 
                    case "jar": 
                    case "war": 
                    case "rar": 
                    case "apk": 
                    case "ear": 
                    case "car": 
                    case "nbm": {
                        return "zip";
                    }
                    case "rpm": {
                        return "rpm";
                    }
                    case "tar": 
                    case "tgz": 
                    case "txz": 
                    case "tbz": 
                    case "tbz2": {
                        return "tar";
                    }
                    case "a": 
                    case "ar": 
                    case "deb": 
                    case "lib": {
                        return "ar";
                    }
                    case "arj": {
                        return "arj";
                    }
                    case "7z": {
                        return "sevenZ";
                    }
                }
                end = start;
            }
        }
        return "unknown";
    }

    public static String toFileUri(@Nullable String hostName, @Nullable String baseDir, @Nullable String fragment) {
        try {
            return new URI("file", hostName, baseDir, fragment).toASCIIString();
        }
        catch (URISyntaxException e) {
            return fragment != null ? baseDir + '#' + fragment : baseDir;
        }
    }

    public static String toNameUri(String name) {
        return ExtraUUIDs.toUriString(ExtraUUIDs.nameUUIDFromBytes(LEGACY_EMITTER_NS, name.toLowerCase(Locale.US).getBytes(StandardCharsets.UTF_8)));
    }

    private static <T> Spliterator<List<T>> partition(final Spliterator<T> source, int averageWeight, final long maxWeight, final ToIntFunction<T> weigher) {
        final int averagePartitionSize = Math.toIntExact(maxWeight / (long)averageWeight);
        long estimatedSize = source.estimateSize() / (long)averagePartitionSize;
        int characteristics = source.characteristics() & 0xFFFFBFBF;
        return new Spliterators.AbstractSpliterator<List<T>>(estimatedSize, characteristics){

            @Override
            public boolean tryAdvance(Consumer<? super List<T>> action) {
                class Partition
                implements Consumer<T> {
                    private final List<T> elements;
                    private long weight;
                    final /* synthetic */ int val$averagePartitionSize;
                    final /* synthetic */ ToIntFunction val$weigher;

                    Partition() {
                        this.val$averagePartitionSize = n;
                        this.val$weigher = toIntFunction;
                        this.elements = new ArrayList(this.val$averagePartitionSize);
                    }

                    @Override
                    public void accept(T element) {
                        this.weight += (long)this.val$weigher.applyAsInt(element);
                        this.elements.add(element);
                    }
                }
                Partition partition = new Partition(averagePartitionSize, weigher);
                while (source.tryAdvance(partition) && partition.weight < maxWeight) {
                }
                if (partition.elements.isEmpty()) {
                    return false;
                }
                action.accept(partition.elements);
                return true;
            }
        };
    }

    @Nullable
    private static String dependencyIdentifier(BdioContext context, Dependency dep) {
        Stream<?> dependsOn = context.getFieldValue(Bdio.ObjectProperty.dependsOn.toString(), dep);
        Stream<?> license = context.getFieldValue(Bdio.ObjectProperty.license.toString(), dep);
        byte[] name = Stream.concat(dependsOn, license).map(Object::toString).collect(Collectors.joining(">,<", "<", ">")).getBytes(StandardCharsets.UTF_8);
        return ExtraUUIDs.toUriString(ExtraUUIDs.nameUUIDFromBytes(DEPENDENCY_IDENTIFIER_NS, name));
    }

    public static final class LegacyScanContainerModule
    extends Module {
        public static final LegacyScanContainerModule INSTANCE = new LegacyScanContainerModule();

        private LegacyScanContainerModule() {
        }

        @Override
        public String getModuleName() {
            return this.getClass().getSimpleName();
        }

        @Override
        public Version version() {
            return Version.unknownVersion();
        }

        @Override
        public void setupModule(Module.SetupContext context) {
            ((ObjectMapper)context.getOwner()).enable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
            ((ObjectMapper)context.getOwner()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    }
}

