/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.Emitter;
import com.blackducksoftware.bdio2.LegacyUtilities;
import com.blackducksoftware.bdio2.model.File;
import com.blackducksoftware.bdio2.model.FileCollection;
import com.blackducksoftware.bdio2.model.Project;
import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.value.Digest;
import com.blackducksoftware.common.value.HID;
import com.blackducksoftware.common.value.Product;
import com.blackducksoftware.common.value.ProductList;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

class LegacyScanContainerEmitter
implements Emitter {
    private final Spliterator<Object> entries;

    public LegacyScanContainerEmitter(InputStream inputStream) {
        this.entries = Stream.of(inputStream).map(LegacyScanContainerEmitter::parseScanContainer).flatMap(LegacyScanContainerEmitter::toBdioEntries).spliterator();
    }

    @Override
    public void emit(Consumer<Object> onNext, Consumer<Throwable> onError2, Runnable onComplete) {
        Objects.requireNonNull(onNext);
        Objects.requireNonNull(onError2);
        Objects.requireNonNull(onComplete);
        try {
            if (!this.entries.tryAdvance(onNext)) {
                onComplete.run();
            }
        }
        catch (UncheckedIOException e) {
            onError2.accept(e.getCause());
        }
        catch (RuntimeException e) {
            onError2.accept(e);
        }
    }

    @Override
    public Stream<Object> stream() {
        return StreamSupport.stream(this.entries, false);
    }

    private static LegacyScanContainer parseScanContainer(InputStream in) {
        try {
            return LegacyUtilities.scanContainerObjectMapper().readValue(in, LegacyScanContainer.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Stream<Object> toBdioEntries(LegacyScanContainer scanContainer) {
        BdioMetadata metadata = scanContainer.metadata();
        Stream<Map<String, Object>> nodes = Stream.concat(Stream.of(scanContainer.rootObject()), scanContainer.files());
        return Stream.concat(Stream.of(metadata.asNamedGraph()), LegacyUtilities.partitionNodes(metadata, nodes).map(graph -> metadata.asNamedGraph(graph, "@id")));
    }

    public static final class LegacyScanContainer {
        @Nullable
        private final String baseDir;
        @Nullable
        private final ZonedDateTime createdOn;
        @Nullable
        private final Long timeToScan;
        @Nullable
        private final String hostName;
        @Nullable
        private final String name;
        @Nullable
        private final String project;
        @Nullable
        private final String release;
        private final ImmutableMap<Long, LegacyScanNode> scanNodeList;
        @Nullable
        private final String scannerVersion;
        @Nullable
        private final String signatureVersion;
        @Nullable
        private final String ownerEntityKeyToken;

        @JsonCreator
        public LegacyScanContainer(@Nullable @JsonProperty(value="baseDir") String baseDir, @Nullable @JsonProperty(value="createdOn") Date createdOn, @Nullable @JsonProperty(value="timeToScan") Long timeToScan, @Nullable @JsonProperty(value="hostName") String hostName, @Nullable @JsonProperty(value="name") String name, @Nullable @JsonProperty(value="project") String project, @Nullable @JsonProperty(value="release") String release, @Nullable @JsonProperty(value="scanNodeList") List<LegacyScanNode> scanNodeList, @Nullable @JsonProperty(value="scannerVersion") String scannerVersion, @Nullable @JsonProperty(value="signatureVersion") String signatureVersion, @Nullable @JsonProperty(value="ownerEntityKeyToken") String ownerEntityKeyToken) {
            this.baseDir = ExtraStrings.removeSuffix(baseDir, "/");
            this.createdOn = createdOn != null ? createdOn.toInstant().atZone(ZoneOffset.UTC) : null;
            this.timeToScan = timeToScan;
            this.hostName = hostName;
            this.name = name;
            this.project = project;
            this.release = release;
            this.scanNodeList = scanNodeList != null ? Maps.uniqueIndex(scanNodeList, scanNode -> ((LegacyScanNode)scanNode).id) : ImmutableMap.of();
            this.scannerVersion = scannerVersion;
            this.signatureVersion = signatureVersion;
            this.ownerEntityKeyToken = ownerEntityKeyToken;
        }

        public BdioMetadata metadata() {
            Optional<String> name = ExtraStrings.ofEmpty(this.name);
            return new BdioMetadata().id(name.map(LegacyUtilities::toNameUri).orElseGet(() -> LegacyUtilities.toFileUri(this.hostName, this.baseDir, null))).name(name.orElseGet(() -> this.hostName + "#" + this.baseDir)).creator(null, this.hostName).creationDateTime(this.createdOn).captureInterval(this.createdOn, this.createdOn != null && this.timeToScan != null ? this.createdOn.plus(this.timeToScan, ChronoUnit.MILLIS) : null).publisher(new ProductList.Builder().addProduct(this.scanClient()).addProduct(new Product.Builder().simpleName(LegacyScanContainerEmitter.class).implementationVersion(LegacyScanContainerEmitter.class).build()).build());
        }

        public Map<String, Object> rootObject() {
            String id = LegacyUtilities.toFileUri(this.hostName, this.baseDir, "root");
            Predicate<LegacyScanNode> isBase = LegacyScanNode.isBase(this.baseDir);
            Optional<LegacyScanNode> baseScanNode = Optional.ofNullable(this.scanNodeList.get(0L)).filter(isBase);
            if (!(baseScanNode.isPresent() || this.scanNodeList.isEmpty() || (baseScanNode = Optional.of((LegacyScanNode)Iterables.getLast(this.scanNodeList.values())).filter(isBase)).isPresent())) {
                baseScanNode = this.scanNodeList.values().stream().filter(isBase).findFirst();
            }
            File base = baseScanNode.map(scanNode -> new File(LegacyUtilities.toFileUri(this.hostName, this.baseDir, scanNode.toString()))).orElse(null);
            if (this.project != null) {
                return new Project(id).name(this.project).version(this.release).base(base);
            }
            return new FileCollection(id).base(base);
        }

        public Stream<Map<String, Object>> files() {
            return this.scanNodeList.values().stream().map(scanNode -> new File(LegacyUtilities.toFileUri(this.hostName, this.baseDir, scanNode.toString())).fileSystemType(scanNode.fileSystemType()).path(scanNode.path(this.baseDir, this.scanNodeList::get)).byteCount(scanNode.byteCount()).fingerprint(scanNode.fingerprint()));
        }

        private Product scanClient() {
            Product.Builder scanClient = new Product.Builder().name("ScanClient").version(this.scannerVersion).addCommentText("signature %s", this.signatureVersion);
            if (this.ownerEntityKeyToken != null && this.ownerEntityKeyToken.startsWith("SP#")) {
                scanClient.addCommentText("snippets", new Object[0]);
            } else if (this.ownerEntityKeyToken != null && this.ownerEntityKeyToken.startsWith("SG#")) {
                scanClient.addCommentText("string_search", new Object[0]);
            }
            return scanClient.build();
        }
    }

    public static final class LegacyScanNode {
        private static final String TYPE_DIRECTORY = "DIRECTORY";
        private static final String TYPE_ARCHIVE = "ARCHIVE";
        private static final String TYPE_FILE = "FILE";
        private static final String TYPE_PLACEHOLDER = "PLACEHOLDER";
        private static final String TYPE_DECLARED_COMPONENT = "DECLARED_COMPONENT";
        private static final String SIGNATURES_SHA1 = "FILE_SHA1";
        private static final String SIGNATURES_MD5 = "FILE_MD5";
        private static final String SIGNATURES_CLEAN_SHA1 = "FILE_CLEAN_SHA1";
        @Nullable
        private final String archiveUri;
        private final long id;
        @Nullable
        private final String name;
        @Nullable
        private final Long parentId;
        @Nullable
        private final String path;
        @Nullable
        private final String uri;
        private final ImmutableMap<String, String> signatures;
        @Nullable
        private final Long size;
        @Nullable
        private final String type;

        @JsonCreator
        public LegacyScanNode(@Nullable @JsonProperty(value="archiveUri") String archiveUri, @Nullable @JsonProperty(value="id") Long id, @Nullable @JsonProperty(value="name") String name, @Nullable @JsonProperty(value="parentId") Long parentId, @Nullable @JsonProperty(value="path") String path, @Nullable @JsonProperty(value="uri") String uri, @Nullable @JsonProperty(value="signatures") Map<String, String> signatures, @Nullable @JsonProperty(value="size") Long size, @Nullable @JsonProperty(value="type") String type) {
            this.archiveUri = archiveUri;
            this.id = id != null ? id : -1L;
            this.name = name;
            this.parentId = parentId;
            this.path = path;
            this.uri = uri;
            this.signatures = signatures != null ? ImmutableMap.copyOf(signatures) : ImmutableMap.of();
            this.size = size;
            this.type = type;
        }

        public String toString() {
            return "scanNode-" + this.id;
        }

        public String path(String baseDir, @Nullable Function<Long, LegacyScanNode> lookup) {
            if (this.uri != null) {
                return this.uri;
            }
            HID.Builder builder = new HID.Builder();
            String scheme = "file";
            if (lookup != null) {
                ArrayDeque<LegacyScanNode> scanNodes = new ArrayDeque<LegacyScanNode>();
                LegacyScanNode scanNode = this;
                while (scanNode != null) {
                    if (Objects.equals(scanNode.type, TYPE_ARCHIVE) || scanNodes.isEmpty()) {
                        scanNodes.push(scanNode);
                    }
                    scanNode = lookup.apply(scanNode.parentId);
                }
                builder.push(scheme, ExtraStrings.ensureDelimiter(baseDir, "/", ((LegacyScanNode)scanNodes.poll()).path));
                scanNodes.forEach(node -> builder.push(LegacyUtilities.guessScheme(builder.peekFilename()), node.nodePath()));
            } else if (this.id == 0L) {
                builder.push(scheme, baseDir);
            } else if (this.archiveUri.isEmpty()) {
                builder.push(scheme, ExtraStrings.ensureDelimiter(baseDir, "/", this.path));
            } else {
                for (String archive : Splitter.on("!/").omitEmptyStrings().split(ExtraStrings.ensureDelimiter(baseDir, "/", this.archiveUri))) {
                    builder.push(scheme, archive);
                    scheme = LegacyUtilities.guessScheme(archive);
                }
                if (!Objects.equals(this.type, TYPE_ARCHIVE)) {
                    builder.push(scheme, this.nodePath());
                }
            }
            return builder.build().toUriString();
        }

        private String nodePath() {
            return ExtraStrings.ensurePrefix("/", Objects.equals(this.name, "/") ? this.name : this.path);
        }

        @Nullable
        public String fileSystemType() {
            if (this.type == null) {
                return null;
            }
            switch (this.type) {
                case "FILE": {
                    if (this.signatures.containsKey(SIGNATURES_CLEAN_SHA1)) {
                        return Bdio.FileSystemType.REGULAR_TEXT.toString();
                    }
                    if (this.signatures.containsKey(SIGNATURES_SHA1)) {
                        return Bdio.FileSystemType.REGULAR_BINARY.toString();
                    }
                    return Bdio.FileSystemType.REGULAR.toString();
                }
                case "ARCHIVE": {
                    return Bdio.FileSystemType.DIRECTORY_ARCHIVE.toString();
                }
                case "DIRECTORY": {
                    return Bdio.FileSystemType.DIRECTORY.toString();
                }
                case "PLACEHOLDER": 
                case "DECLARED_COMPONENT": {
                    return null;
                }
            }
            throw new IllegalArgumentException("invalid file type: " + this.type);
        }

        @Nullable
        public Long byteCount() {
            return this.type == null || this.type.equals(TYPE_FILE) || this.type.equals(TYPE_ARCHIVE) ? this.size : null;
        }

        @Nullable
        public List<Digest> fingerprint() {
            if (this.signatures.isEmpty()) {
                return null;
            }
            return this.signatures.entrySet().stream().map(e -> new Digest.Builder().algorithm(LegacyScanNode.algorithmName((String)e.getKey())).value((CharSequence)e.getValue()).build()).collect(Collectors.collectingAndThen(Collectors.toList(), l -> l.isEmpty() ? null : l));
        }

        private static String algorithmName(String signatureType) {
            switch (signatureType) {
                case "FILE_SHA1": {
                    return "sha1";
                }
                case "FILE_MD5": {
                    return "md5";
                }
                case "FILE_CLEAN_SHA1": {
                    return "sha1-ascii";
                }
            }
            return "unknown";
        }

        public static Predicate<LegacyScanNode> isBase(String baseDir) {
            try {
                String baseUri = HID.valueOf(new URI("file", null, baseDir, null).toString()).toUriString();
                String baseArchiveUri = "file:" + ExtraStrings.beforeLast(baseDir, '/') + "/";
                String baseName = ExtraStrings.afterLast(baseDir, '/');
                return scanNode -> Objects.equals(scanNode.uri, baseUri) || Objects.equals("/", scanNode.path) && Objects.equals(scanNode.archiveUri, baseArchiveUri) && Objects.equals(scanNode.name, baseName);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }
}

