/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.BdioWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class BdioSubscriber
implements Subscriber<Map<String, Object>> {
    private final BdioWriter writer;
    private final Consumer<Throwable> onError;
    private Subscription subscription;

    public BdioSubscriber(BdioMetadata metadata, BdioWriter.StreamSupplier entryStreams, Consumer<Throwable> onError2) {
        this.writer = new BdioWriter(metadata, entryStreams);
        this.onError = Objects.requireNonNull(onError2);
    }

    private void validateSubscription(Subscription s2) {
        Objects.requireNonNull(s2, "subscription is null");
        if (this.subscription != null) {
            this.subscription.cancel();
            throw new IllegalStateException("subscription was already set");
        }
        this.subscription = s2;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        this.validateSubscription(s2);
        try {
            this.writer.start();
            this.subscription.request(Long.MAX_VALUE);
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    @Override
    public void onNext(Map<String, Object> node) {
        try {
            this.writer.next(node);
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    @Override
    public void onComplete() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            this.onError.accept(e);
        }
    }

    @Override
    public void onError(Throwable e) {
        try {
            this.writer.close();
        }
        catch (IOException | RuntimeException suppressed) {
            e.addSuppressed(suppressed);
        }
        this.onError.accept(e);
    }
}

