/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.EntrySizeViolationException;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;

public class BdioReader
implements Closeable {
    private static byte[] ZIP_MAGIC = new byte[]{80, 75, 3, 4};
    private final InputStream in;
    private State state = State.OPEN;
    @Nullable
    private ZipInputStream zip;

    public BdioReader(InputStream in) {
        this.in = Objects.requireNonNull(in);
    }

    @Nullable
    public Object nextEntry() throws IOException {
        try (InputStream input = this.nextStream();){
            Object object = input != null ? JsonUtils.fromInputStream(input) : null;
            return object;
        }
    }

    @Nullable
    private synchronized InputStream nextStream() throws IOException {
        switch (this.state) {
            case OPEN: {
                if (BdioReader.isZipFile(this.in)) {
                    this.zip = new ZipInputStream(this.in, StandardCharsets.UTF_8);
                    this.state = State.ZIP;
                } else {
                    this.state = State.JSON;
                }
                return this.nextStream();
            }
            case ZIP: {
                ZipEntry entry = this.zip.getNextEntry();
                while (entry != null) {
                    if (Bdio.isDataEntryName(entry.getName())) {
                        return new JsonInputStream(this.zip, entry.getName(), entry.getSize());
                    }
                    entry = this.zip.getNextEntry();
                }
                this.close();
                return null;
            }
            case JSON: {
                this.state = State.CLOSED;
                return new JsonInputStream(this.in);
            }
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.zip != null) {
                this.zip.close();
            } else {
                this.in.close();
            }
        }
        finally {
            this.state = State.CLOSED;
        }
    }

    private static boolean isZipFile(InputStream in) throws IOException {
        byte[] signature = new byte[ZIP_MAGIC.length];
        in.mark(signature.length);
        int len = in.read(signature);
        in.reset();
        return len == signature.length && Arrays.equals(signature, ZIP_MAGIC);
    }

    private static enum State {
        OPEN,
        ZIP,
        JSON,
        CLOSED;

    }

    private static final class JsonInputStream
    extends FilterInputStream {
        private int remaining = 0x1000000;
        @Nullable
        private final String name;
        private final long estimatedSize;

        private JsonInputStream(InputStream in) {
            super(in);
            this.name = null;
            this.estimatedSize = -1L;
        }

        private JsonInputStream(InputStream in, String name, long estimatedSize) {
            super(in);
            this.name = Objects.requireNonNull(name);
            this.estimatedSize = estimatedSize < 0L ? -1L : estimatedSize;
        }

        private void checkRemaining() throws IOException {
            if (this.remaining == 0) {
                throw new EntrySizeViolationException(this.name, this.estimatedSize);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.in instanceof ZipInputStream) {
                ((ZipInputStream)this.in).closeEntry();
            } else {
                super.close();
            }
        }

        @Override
        public int available() throws IOException {
            return Math.min(this.in.available(), this.remaining);
        }

        @Override
        public int read() throws IOException {
            this.checkRemaining();
            int result = super.read();
            if (result != -1) {
                --this.remaining;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkRemaining();
            int result = this.in.read(b, off, Math.min(len, this.remaining));
            if (result != -1) {
                this.remaining -= result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            int result = (int)this.in.skip(Math.min(n, (long)this.remaining));
            this.remaining -= result;
            return result;
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

