/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioContext;
import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.base.ExtraUUIDs;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class BdioObject
extends AbstractMap<String, Object> {
    private final BdioContext context;
    private final Map<String, Object> data;

    protected BdioObject(String id, Bdio.Class bdioClass) {
        this.context = BdioContext.getDefault();
        this.data = new LinkedHashMap<String, Object>();
        this.put("@id", (Object)Objects.requireNonNull(id));
        this.put("@type", (Object)bdioClass.toString());
    }

    protected BdioObject(Bdio.Class bdioClass) {
        this.context = BdioContext.getDefault();
        this.data = new LinkedHashMap<String, Object>();
        this.put("@type", (Object)bdioClass.toString());
    }

    BdioObject(Map<String, Object> initialValues) {
        this.context = BdioContext.getDefault();
        this.data = new LinkedHashMap<String, Object>(initialValues);
    }

    BdioObject() {
        this.context = new BdioContext.Builder().build();
        this.data = new LinkedHashMap<String, Object>();
    }

    public static String randomId() {
        return ExtraUUIDs.toUriString(UUID.randomUUID());
    }

    @Override
    public final Set<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public final Set<String> keySet() {
        return this.data.keySet();
    }

    @Override
    public final Object get(@Nullable Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object put(String key, @Nullable Object value) {
        Objects.requireNonNull(key, "key must not be null");
        return value != null ? this.data.put(key, value) : this.data.remove(key);
    }

    @Nullable
    public final String id() {
        Object value = this.get("@id");
        Preconditions.checkState(value == null || value instanceof String, "identifier is not mapped to a string");
        return ExtraStrings.beforeLast((String)value, '#');
    }

    protected Object putFieldValue(Object field2, @Nullable Object value) {
        return this.context.putFieldValue(this, field2, value);
    }

    protected Object fromFieldValue(String term, @Nullable Object input) {
        return this.context.fromFieldValue(term, input);
    }
}

