/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.BdioReader;
import com.blackducksoftware.bdio2.Emitter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Consumer;

public class BdioEmitter
implements Emitter {
    private final BdioReader reader;

    public BdioEmitter(InputStream in) {
        this.reader = new BdioReader(in);
    }

    @Override
    public void emit(Consumer<Object> onNext, Consumer<Throwable> onError2, Runnable onComplete) {
        Objects.requireNonNull(onNext);
        Objects.requireNonNull(onError2);
        Objects.requireNonNull(onComplete);
        try {
            Object next = this.reader.nextEntry();
            if (next != null) {
                onNext.accept(next);
            } else {
                onComplete.run();
            }
        }
        catch (IOException e) {
            onError2.accept(e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

