/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.List;

public abstract class JarResourceCopier {
    public List<File> copy(String resourceDir, String destinationDir) throws IOException, URISyntaxException {
        List<String> fileList = this.findRelativePathFileList();
        return this.writeFiles(fileList, resourceDir, destinationDir);
    }

    public abstract List<String> findRelativePathFileList();

    private List<File> writeFiles(List<String> fileList, String resourceDir, String destinationDir) throws IOException {
        LinkedList<File> writtenList = new LinkedList<File>();
        for (String relativePath : fileList) {
            String destFile;
            String resourceFile = resourceDir + relativePath;
            if (this.copyFileViaClass(resourceFile, destFile = destinationDir + File.separator + relativePath, writtenList)) continue;
            this.copyFileViaClassLoader(resourceFile, destFile, writtenList);
        }
        return writtenList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyFileViaClass(String resourcePath, String destFile, List<File> writtenFileList) throws IOException {
        try (InputStream resourceStream = this.getClassInputStream(resourcePath);){
            if (resourceStream == null) {
                boolean bl2 = false;
                return bl2;
            }
            this.copyFile(resourceStream, destFile, writtenFileList);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyFileViaClassLoader(String resourcePath, String destFile, List<File> writtenFileList) throws IOException {
        try (InputStream resourceStream = this.getClassLoaderInputStream(resourcePath);){
            if (resourceStream == null) {
                boolean bl2 = false;
                return bl2;
            }
            this.copyFile(resourceStream, destFile, writtenFileList);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void copyFile(InputStream resourceStream, String destFile, List<File> writtenFileList) throws IOException {
        File filePath = new File(destFile);
        filePath.getParentFile().mkdirs();
        Files.copy(resourceStream, filePath.toPath(), StandardCopyOption.REPLACE_EXISTING);
        writtenFileList.add(filePath);
    }

    private InputStream getClassLoaderInputStream(String resourcePath) {
        return this.getClass().getClassLoader().getResourceAsStream(resourcePath);
    }

    private InputStream getClassInputStream(String resourcePath) {
        return this.getClass().getResourceAsStream(resourcePath);
    }
}

