/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http;

import com.synopsys.integration.blackduck.http.BlackDuckPageDefinition;
import com.synopsys.integration.blackduck.http.BlackDuckRequestBuilder;
import com.synopsys.integration.rest.request.Request;
import java.util.HashSet;
import org.apache.commons.lang3.math.NumberUtils;

public class PagedRequest {
    private final BlackDuckRequestBuilder requestBuilder;
    private final int offset;
    private final int limit;

    public PagedRequest(BlackDuckRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
        int offset = 0;
        int limit = 100;
        if (requestBuilder.getQueryParameters() != null) {
            if (requestBuilder.getQueryParameters().containsKey("offset")) {
                offset = NumberUtils.toInt((String)requestBuilder.getQueryParameters().get("offset").stream().findFirst().orElse(null), (int)offset);
            }
            if (requestBuilder.getQueryParameters().containsKey("limit")) {
                limit = NumberUtils.toInt((String)requestBuilder.getQueryParameters().get("limit").stream().findFirst().orElse(null), (int)limit);
            }
        }
        this.offset = offset;
        this.limit = limit;
    }

    public PagedRequest(BlackDuckRequestBuilder requestBuilder, int offset, int limit) {
        this.requestBuilder = requestBuilder;
        this.offset = offset;
        this.limit = limit;
    }

    public PagedRequest(BlackDuckRequestBuilder requestBuilder, BlackDuckPageDefinition blackDuckPageDefinition) {
        this.requestBuilder = requestBuilder;
        this.offset = blackDuckPageDefinition.getOffset();
        this.limit = blackDuckPageDefinition.getLimit();
    }

    public Request createRequest() {
        Request request = (Request)this.requestBuilder.getRequestBuilder().build();
        HashSet<String> limitValue = new HashSet<String>();
        limitValue.add(String.valueOf(this.getLimit()));
        HashSet<String> offsetValue = new HashSet<String>();
        offsetValue.add(String.valueOf(this.getOffset()));
        request.getQueryParameters().put("limit", limitValue);
        request.getQueryParameters().put("offset", offsetValue);
        return request;
    }

    public BlackDuckRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }
}

