/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.synopsys.integration.blackduck.codelocation.CodeLocationCreationService;
import com.synopsys.integration.blackduck.codelocation.CodeLocationWaiter;
import com.synopsys.integration.blackduck.codelocation.bdio2upload.Bdio2UploadService;
import com.synopsys.integration.blackduck.codelocation.bdio2upload.UploadBdio2BatchRunner;
import com.synopsys.integration.blackduck.codelocation.bdioupload.BdioUploadService;
import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadBatchRunner;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanBatchRunner;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanUploadService;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.ScanBatchRunner;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.SignatureScannerService;
import com.synopsys.integration.blackduck.developermode.RapidScanBdio2Reader;
import com.synopsys.integration.blackduck.developermode.RapidScanBdio2Uploader;
import com.synopsys.integration.blackduck.developermode.RapidScanService;
import com.synopsys.integration.blackduck.developermode.RapidScanWaiter;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.transform.BlackDuckJsonTransformer;
import com.synopsys.integration.blackduck.http.transform.BlackDuckResponseTransformer;
import com.synopsys.integration.blackduck.http.transform.BlackDuckResponsesTransformer;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.bucket.BlackDuckBucketService;
import com.synopsys.integration.blackduck.service.dataservice.BlackDuckRegistrationService;
import com.synopsys.integration.blackduck.service.dataservice.CodeLocationService;
import com.synopsys.integration.blackduck.service.dataservice.ComponentService;
import com.synopsys.integration.blackduck.service.dataservice.IssueService;
import com.synopsys.integration.blackduck.service.dataservice.LicenseService;
import com.synopsys.integration.blackduck.service.dataservice.NotificationService;
import com.synopsys.integration.blackduck.service.dataservice.PolicyRuleService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectBomService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectGetService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectMappingService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectUsersService;
import com.synopsys.integration.blackduck.service.dataservice.ReportService;
import com.synopsys.integration.blackduck.service.dataservice.RoleService;
import com.synopsys.integration.blackduck.service.dataservice.TagService;
import com.synopsys.integration.blackduck.service.dataservice.UserGroupService;
import com.synopsys.integration.blackduck.service.dataservice.UserRoleService;
import com.synopsys.integration.blackduck.service.dataservice.UserService;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.IntegrationEscapeUtil;
import com.synopsys.integration.util.NoThreadExecutorService;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BlackDuckServicesFactory {
    public static final ExecutorService NO_THREAD_EXECUTOR_SERVICE = new NoThreadExecutorService();
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final Gson gson;
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService;
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final IntLogger logger;
    private final BlackDuckRequestFactory blackDuckRequestFactory;
    private final BlackDuckJsonTransformer blackDuckJsonTransformer;
    private final BlackDuckResponseTransformer blackDuckResponseTransformer;
    private final BlackDuckResponsesTransformer blackDuckResponsesTransformer;
    private final BlackDuckApiClient blackDuckApiClient;

    public BlackDuckServicesFactory(IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, ExecutorService executorService, BlackDuckHttpClient blackDuckHttpClient, IntLogger logger, BlackDuckRequestFactory blackDuckRequestFactory) {
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.gson = gson;
        this.objectMapper = objectMapper;
        this.executorService = executorService;
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.logger = logger;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
        this.blackDuckJsonTransformer = new BlackDuckJsonTransformer(gson, objectMapper, logger);
        this.blackDuckResponseTransformer = new BlackDuckResponseTransformer(blackDuckHttpClient, this.blackDuckJsonTransformer);
        this.blackDuckResponsesTransformer = new BlackDuckResponsesTransformer(blackDuckHttpClient, this.blackDuckJsonTransformer);
        this.blackDuckApiClient = new BlackDuckApiClient(blackDuckHttpClient, gson, this.blackDuckJsonTransformer, this.blackDuckResponseTransformer, this.blackDuckResponsesTransformer, blackDuckRequestFactory);
    }

    public static Gson createDefaultGson() {
        return BlackDuckServicesFactory.createDefaultGsonBuilder().create();
    }

    public static ObjectMapper createDefaultObjectMapper() {
        return new ObjectMapper();
    }

    public static GsonBuilder createDefaultGsonBuilder() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    }

    public static BlackDuckRequestFactory createDefaultRequestFactory() {
        return new BlackDuckRequestFactory();
    }

    public BdioUploadService createBdioUploadService() {
        return new BdioUploadService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, new UploadBatchRunner(this.logger, this.blackDuckApiClient, this.blackDuckRequestFactory, this.executorService), this.createCodeLocationCreationService());
    }

    public Bdio2UploadService createBdio2UploadService() {
        return new Bdio2UploadService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, new UploadBdio2BatchRunner(this.logger, this.blackDuckApiClient, this.blackDuckRequestFactory, this.executorService), this.createCodeLocationCreationService());
    }

    public BlackDuckBucketService createBlackDuckBucketService() {
        return new BlackDuckBucketService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, this.executorService);
    }

    public SignatureScannerService createSignatureScannerService() {
        ScanBatchRunner scanBatchRunner = ScanBatchRunner.createDefault(this.logger, this.blackDuckHttpClient, this.intEnvironmentVariables, this.executorService);
        return this.createSignatureScannerService(scanBatchRunner);
    }

    public SignatureScannerService createSignatureScannerService(ScanBatchRunner scanBatchRunner) {
        return new SignatureScannerService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, scanBatchRunner, this.createCodeLocationCreationService());
    }

    public BinaryScanUploadService createBinaryScanUploadService() {
        return new BinaryScanUploadService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, new BinaryScanBatchRunner(this.logger, this.blackDuckApiClient, this.blackDuckRequestFactory, this.executorService), this.createCodeLocationCreationService());
    }

    public CodeLocationCreationService createCodeLocationCreationService() {
        ProjectService projectService = this.createProjectService();
        NotificationService notificationService = this.createNotificationService();
        CodeLocationWaiter codeLocationWaiter = new CodeLocationWaiter(this.logger, this.blackDuckApiClient, projectService, notificationService);
        return new CodeLocationCreationService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, codeLocationWaiter, notificationService);
    }

    public CodeLocationService createCodeLocationService() {
        return new CodeLocationService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public ComponentService createComponentService() {
        return new ComponentService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public BlackDuckRegistrationService createBlackDuckRegistrationService() {
        return new BlackDuckRegistrationService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, this.blackDuckHttpClient.getBaseUrl());
    }

    public IssueService createIssueService() {
        return new IssueService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public LicenseService createLicenseService() {
        return new LicenseService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, this.createComponentService());
    }

    public NotificationService createNotificationService() {
        return new NotificationService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public PolicyRuleService createPolicyRuleService() {
        return new PolicyRuleService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public ProjectService createProjectService() {
        ProjectGetService projectGetService = new ProjectGetService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
        return new ProjectService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, projectGetService);
    }

    public ProjectBomService createProjectBomService() {
        return new ProjectBomService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, this.createComponentService());
    }

    public ProjectUsersService createProjectUsersService() {
        UserGroupService userGroupService = this.createUserGroupService();
        return new ProjectUsersService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, userGroupService);
    }

    public ReportService createReportService(long timeoutInMilliseconds) {
        return new ReportService(this.gson, this.blackDuckHttpClient.getBaseUrl(), this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger, this.createProjectService(), this.createIntegrationEscapeUtil(), timeoutInMilliseconds);
    }

    public UserService createUserService() {
        return new UserService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public RoleService createRoleService() {
        return new RoleService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public UserRoleService createUserRoleService() {
        return new UserRoleService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public UserGroupService createUserGroupService() {
        return new UserGroupService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public ProjectMappingService createProjectMappingService() {
        return new ProjectMappingService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public TagService createTagService() {
        return new TagService(this.blackDuckApiClient, this.blackDuckRequestFactory, this.logger);
    }

    public RapidScanService createRapidScanService() {
        RapidScanBdio2Reader bdio2Reader = new RapidScanBdio2Reader();
        RapidScanWaiter rapidScanWaiter = new RapidScanWaiter(this.logger, this.blackDuckApiClient);
        RapidScanBdio2Uploader bdio2Uploader = new RapidScanBdio2Uploader(this.blackDuckApiClient, this.blackDuckRequestFactory);
        return new RapidScanService(bdio2Reader, bdio2Uploader, rapidScanWaiter);
    }

    public IntegrationEscapeUtil createIntegrationEscapeUtil() {
        return new IntegrationEscapeUtil();
    }

    public BlackDuckHttpClient getBlackDuckHttpClient() {
        return this.blackDuckHttpClient;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public IntEnvironmentVariables getEnvironmentVariables() {
        return this.intEnvironmentVariables;
    }

    public BlackDuckApiClient getBlackDuckApiClient() {
        return this.blackDuckApiClient;
    }

    public BlackDuckRequestFactory getRequestFactory() {
        return this.blackDuckRequestFactory;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

