/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.binaryscanner;

import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScan;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanBatch;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanBatchOutput;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanCallable;
import com.synopsys.integration.blackduck.codelocation.binaryscanner.BinaryScanOutput;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class BinaryScanBatchRunner {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final BlackDuckRequestFactory blackDuckRequestFactory;
    private final ExecutorService executorService;

    public BinaryScanBatchRunner(IntLogger logger, BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, ExecutorService executorService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
        this.executorService = executorService;
    }

    public BinaryScanBatchOutput executeUploads(BinaryScanBatch binaryScanBatch) throws BlackDuckIntegrationException {
        this.logger.info("Starting the binary scan file uploads.");
        BinaryScanBatchOutput binaryScanBatchOutput = this.uploadFiles(binaryScanBatch);
        this.logger.info("Completed the binary scan file uploads.");
        return binaryScanBatchOutput;
    }

    private BinaryScanBatchOutput uploadFiles(BinaryScanBatch binaryScanBatch) throws BlackDuckIntegrationException {
        ArrayList<BinaryScanOutput> uploadOutputs = new ArrayList<BinaryScanOutput>();
        try {
            List<BinaryScanCallable> callables = this.createCallables(binaryScanBatch);
            ArrayList<Future<BinaryScanOutput>> submitted = new ArrayList<Future<BinaryScanOutput>>();
            for (BinaryScanCallable binaryScanCallable : callables) {
                submitted.add(this.executorService.submit(binaryScanCallable));
            }
            for (Future future : submitted) {
                BinaryScanOutput uploadOutput = (BinaryScanOutput)future.get();
                uploadOutputs.add(uploadOutput);
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException(String.format("Encountered a problem uploading a binary file: %s", e.getMessage()), e);
        }
        return new BinaryScanBatchOutput((List<BinaryScanOutput>)uploadOutputs);
    }

    private List<BinaryScanCallable> createCallables(BinaryScanBatch uploadBatch) {
        List<BinaryScanCallable> callables = uploadBatch.getBinaryScans().stream().map(binaryScan -> new BinaryScanCallable(this.blackDuckApiClient, this.blackDuckRequestFactory, (BinaryScan)binaryScan)).collect(Collectors.toList());
        return callables;
    }
}

