/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.ScanBatch;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.BlackDuckOnlineProperties;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.IndividualFileMatching;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanTarget;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.SnippetMatching;
import com.synopsys.integration.blackduck.configuration.BlackDuckServerConfig;
import com.synopsys.integration.builder.BuilderStatus;
import com.synopsys.integration.builder.IntegrationBuilder;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScanBatchBuilder
extends IntegrationBuilder<ScanBatch> {
    public static final int DEFAULT_MEMORY_IN_MEGABYTES = 4096;
    public static final int MINIMUM_MEMORY_IN_MEGABYTES = 256;
    private File installDirectory;
    private File outputDirectory;
    private boolean cleanupOutput;
    private int scanMemoryInMegabytes = 4096;
    private boolean dryRun;
    private boolean debug;
    private boolean verbose = true;
    private String scanCliOpts;
    private String additionalScanArguments;
    private SnippetMatching snippetMatching;
    private boolean uploadSource;
    private boolean licenseSearch;
    private boolean copyrightSearch;
    private IndividualFileMatching individualFileMatching;
    private HttpUrl blackDuckUrl;
    private String blackDuckUsername;
    private String blackDuckPassword;
    private String blackDuckApiToken;
    private ProxyInfo proxyInfo = ProxyInfo.NO_PROXY_INFO;
    private boolean alwaysTrustServerCertificate;
    private String projectName;
    private String projectVersionName;
    private List<ScanTarget> scanTargets = new ArrayList<ScanTarget>();

    @Override
    protected ScanBatch buildWithoutValidation() {
        BlackDuckOnlineProperties blackDuckOnlineProperties = new BlackDuckOnlineProperties(this.snippetMatching, this.uploadSource, this.licenseSearch, this.copyrightSearch);
        return new ScanBatch(this.installDirectory, this.outputDirectory, this.cleanupOutput, this.scanMemoryInMegabytes, this.dryRun, this.debug, this.verbose, this.scanCliOpts, this.additionalScanArguments, blackDuckOnlineProperties, this.individualFileMatching, this.blackDuckUrl, this.blackDuckUsername, this.blackDuckPassword, this.blackDuckApiToken, this.proxyInfo, this.alwaysTrustServerCertificate, this.projectName, this.projectVersionName, this.scanTargets);
    }

    @Override
    protected void validate(BuilderStatus builderStatus) {
        if (this.scanTargets == null || this.scanTargets.size() < 1) {
            builderStatus.addErrorMessage("At least one target path must be provided.");
        } else {
            for (ScanTarget scanTarget : this.scanTargets) {
                this.validateScanTarget(builderStatus, scanTarget);
            }
        }
        if (this.blackDuckUrl != null) {
            this.validateBlackDuckCredentials(builderStatus);
        }
        if (this.scanMemoryInMegabytes < 256) {
            builderStatus.addErrorMessage(String.format("The minimum amount of memory for the scan is %d MB.", 256));
        }
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.projectName, this.projectVersionName}) && (StringUtils.isBlank((CharSequence)this.projectName) || StringUtils.isBlank((CharSequence)this.projectVersionName))) {
            builderStatus.addErrorMessage("Both projectName and projectVersionName must be provided or omitted together");
        }
        if (this.blackDuckUrl != null && this.proxyInfo == null) {
            builderStatus.addErrorMessage("Must provide proxy info.");
        }
    }

    private void validateBlackDuckCredentials(BuilderStatus builderStatus) {
        if (StringUtils.isNotBlank((CharSequence)this.blackDuckApiToken)) {
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.blackDuckUsername, this.blackDuckPassword})) {
            builderStatus.addErrorMessage("Either an api token or a username and password is required.");
        }
    }

    private void validateScanTarget(BuilderStatus builderStatus, ScanTarget scanTarget) {
        try {
            new File(scanTarget.getPath()).getCanonicalPath();
        }
        catch (IOException e) {
            builderStatus.addErrorMessage(String.format("The target path: %s is not valid since its canonical path could not be determined: %s.", scanTarget.getPath(), e.getMessage()));
        }
        for (String exclusionPattern : scanTarget.getExclusionPatterns()) {
            if (exclusionPattern.startsWith("/") && exclusionPattern.endsWith("/") && !exclusionPattern.contains("**")) continue;
            builderStatus.addErrorMessage("The exclusion pattern: " + exclusionPattern + " is not valid. An exclusion pattern must start and end with a forward slash (/) and may not contain double asterisks (**).");
        }
    }

    public ScanBatchBuilder fromBlackDuckServerConfig(BlackDuckServerConfig blackDuckServerConfig) {
        if (null == blackDuckServerConfig) {
            this.proxyInfo = ProxyInfo.NO_PROXY_INFO;
            this.blackDuckUrl = null;
            this.blackDuckUsername = null;
            this.blackDuckPassword = null;
            this.blackDuckApiToken = null;
            this.alwaysTrustServerCertificate = false;
        } else {
            this.proxyInfo = blackDuckServerConfig.getProxyInfo();
            this.blackDuckUrl = blackDuckServerConfig.getBlackDuckUrl();
            if (blackDuckServerConfig.usingApiToken()) {
                this.blackDuckApiToken = blackDuckServerConfig.getApiToken().orElse(null);
            } else if (blackDuckServerConfig.getCredentials().isPresent()) {
                this.blackDuckUsername = blackDuckServerConfig.getCredentials().get().getUsername().orElse(null);
                this.blackDuckPassword = blackDuckServerConfig.getCredentials().get().getPassword().orElse(null);
            }
            this.alwaysTrustServerCertificate = blackDuckServerConfig.isAlwaysTrustServerCertificate();
        }
        return this;
    }

    public ScanBatchBuilder addTarget(ScanTarget scanTarget) {
        this.scanTargets.add(scanTarget);
        return this;
    }

    public ScanBatchBuilder addTargets(List<ScanTarget> scanTargets) {
        this.scanTargets.addAll(scanTargets);
        return this;
    }

    public ScanBatchBuilder projectAndVersionNames(String projectName, String projectVersionName) {
        this.projectName = projectName;
        this.projectVersionName = projectVersionName;
        return this;
    }

    public File getInstallDirectory() {
        return this.installDirectory;
    }

    public ScanBatchBuilder installDirectory(File installDirectory) {
        this.installDirectory = installDirectory;
        return this;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public ScanBatchBuilder outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public boolean isCleanupOutput() {
        return this.cleanupOutput;
    }

    public ScanBatchBuilder cleanupOutput(boolean cleanupOutput) {
        this.cleanupOutput = cleanupOutput;
        return this;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public ScanBatchBuilder scanMemoryInMegabytes(int scanMemoryInMegabytes) {
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public ScanBatchBuilder dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ScanBatchBuilder debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ScanBatchBuilder verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public ScanBatchBuilder scanCliOpts(String scanCliOpts) {
        this.scanCliOpts = scanCliOpts;
        return this;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public ScanBatchBuilder additionalScanArguments(String additionalScanArguments) {
        this.additionalScanArguments = additionalScanArguments;
        return this;
    }

    public SnippetMatching getSnippetMatching() {
        return this.snippetMatching;
    }

    public ScanBatchBuilder snippetMatching(SnippetMatching snippetMatching) {
        this.snippetMatching = snippetMatching;
        return this;
    }

    public boolean getUploadSource() {
        return this.uploadSource;
    }

    public ScanBatchBuilder uploadSource(SnippetMatching snippetMatching, boolean uploadSource) {
        this.snippetMatching(snippetMatching);
        this.uploadSource = uploadSource;
        return this;
    }

    public ScanBatchBuilder uploadSource(boolean uploadSource) {
        this.uploadSource = uploadSource;
        return this;
    }

    public boolean isLicenseSearch() {
        return this.licenseSearch;
    }

    public void licenseSearch(boolean licenseSearch) {
        this.licenseSearch = licenseSearch;
    }

    public boolean getCopyrightSearch() {
        return this.copyrightSearch;
    }

    public void copyrightSearch(boolean copyrightSearch) {
        this.copyrightSearch = copyrightSearch;
    }

    public IndividualFileMatching getIndividualFileMatching() {
        return this.individualFileMatching;
    }

    public void individualFileMatching(IndividualFileMatching individualFileMatching) {
        this.individualFileMatching = individualFileMatching;
    }

    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public ScanBatchBuilder blackDuckUrl(HttpUrl blackDuckUrl) {
        this.blackDuckUrl = blackDuckUrl;
        return this;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public ScanBatchBuilder blackDuckUsername(String blackDuckUsername) {
        this.blackDuckUsername = blackDuckUsername;
        return this;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public ScanBatchBuilder blackDuckPassword(String blackDuckPassword) {
        this.blackDuckPassword = blackDuckPassword;
        return this;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public ScanBatchBuilder blackDuckApiToken(String blackDuckApiToken) {
        this.blackDuckApiToken = blackDuckApiToken;
        return this;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public ScanBatchBuilder proxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
        return this;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public ScanBatchBuilder alwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersionName() {
        return this.projectVersionName;
    }

    public List<ScanTarget> getScanTargets() {
        return this.scanTargets;
    }

    public ScanBatchBuilder simpleScanTargets(List<ScanTarget> scanTargets) {
        this.scanTargets = scanTargets;
        return this;
    }
}

