/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio;

import com.synopsys.integration.bdio.graph.DependencyGraph;
import com.synopsys.integration.bdio.graph.MutableMapDependencyGraph;
import com.synopsys.integration.bdio.model.BdioComponent;
import com.synopsys.integration.bdio.model.BdioId;
import com.synopsys.integration.bdio.model.BdioProject;
import com.synopsys.integration.bdio.model.BdioRelationship;
import com.synopsys.integration.bdio.model.Forge;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import com.synopsys.integration.bdio.model.externalid.ExternalId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BdioTransformer {
    private final Map<String, Forge> forgeMap;

    public BdioTransformer() {
        this.forgeMap = Forge.getKnownForges();
    }

    public BdioTransformer(Map<String, Forge> forgeMap) {
        this.forgeMap = forgeMap;
    }

    public DependencyGraph transformToDependencyGraph(BdioProject project, List<BdioComponent> components) {
        MutableMapDependencyGraph dependencyGraph = new MutableMapDependencyGraph();
        HashMap<BdioId, Dependency> bdioIdToDependencyMap = new HashMap<BdioId, Dependency>();
        for (BdioComponent component : components) {
            ExternalId externalId = component.bdioExternalIdentifier.externalIdMetaData;
            if (externalId == null) {
                Forge forge = this.forgeMap.get(component.bdioExternalIdentifier.forge);
                externalId = ExternalId.createFromExternalId(forge, component.bdioExternalIdentifier.externalId, component.name, component.version);
            }
            Dependency dependency = new Dependency(component.name, component.version, externalId);
            bdioIdToDependencyMap.put(component.id, dependency);
        }
        for (BdioRelationship relation : project.relationships) {
            dependencyGraph.addChildrenToRoot((Dependency)bdioIdToDependencyMap.get(relation.related));
        }
        for (BdioComponent component : components) {
            Dependency dependency = (Dependency)bdioIdToDependencyMap.get(component.id);
            for (BdioRelationship relation : component.relationships) {
                dependencyGraph.addParentWithChild(dependency, (Dependency)bdioIdToDependencyMap.get(relation.related));
            }
        }
        return dependencyGraph;
    }
}

