/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.synopsys.integration.bdio.model.BdioBillOfMaterials;
import com.synopsys.integration.bdio.model.BdioComponent;
import com.synopsys.integration.bdio.model.BdioProject;
import com.synopsys.integration.bdio.model.SimpleBdioDocument;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class BdioReader
implements Closeable {
    private final Gson gson;
    private final JsonReader jsonReader;

    public BdioReader(Gson gson, Reader reader) throws IOException {
        this.gson = gson;
        this.jsonReader = new JsonReader(reader);
        this.jsonReader.beginArray();
    }

    public BdioReader(Gson gson, InputStream inputStream) throws IOException {
        this.gson = gson;
        this.jsonReader = new JsonReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        this.jsonReader.beginArray();
    }

    public SimpleBdioDocument readSimpleBdioDocument() throws IOException {
        SimpleBdioDocument document = new SimpleBdioDocument();
        document.setBillOfMaterials(this.readBillOfMaterials());
        document.setProject(this.readProject());
        while (this.jsonReader.hasNext()) {
            document.getComponents().add(this.readComponent());
        }
        return document;
    }

    public BdioBillOfMaterials readBillOfMaterials() {
        return (BdioBillOfMaterials)this.gson.fromJson(this.jsonReader, (Type)((Object)BdioBillOfMaterials.class));
    }

    public BdioProject readProject() {
        return (BdioProject)this.gson.fromJson(this.jsonReader, (Type)((Object)BdioProject.class));
    }

    public BdioComponent readComponent() {
        return (BdioComponent)this.gson.fromJson(this.jsonReader, (Type)((Object)BdioComponent.class));
    }

    @Override
    public void close() throws IOException {
        this.jsonReader.endArray();
        this.jsonReader.close();
    }
}

