#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.plugin.blackduck import RestConnectionHelper
from com.synopsys.integration.blackduck.api.generated.view import ProjectVersionView
from java.lang import String
from java.lang import Exception

class HubServicesHelper:
    BASE_URL = ""
    def __init__(self, params):
        if String(params.get('url')).endsWith('/'):
            self.BASE_URL = params.get('url')[:-1]
        else:
            self.BASE_URL = params.get('url')
        self.__server_params = params
        self.__connection_helper = RestConnectionHelper(
            self.__server_params['url'],
            self.__server_params['username'],
            self.__server_params['password'],
            self.__server_params['apiToken'],
            self.__server_params['proxyHost'],
            self.__server_params['proxyPort'],
            self.__server_params['proxyUsername'],
            self.__server_params['proxyPassword'],
            self.__server_params['proxyDomain'],
            self.__server_params['trustCertificate']
        )

    def get_project_view(self, project_name):
        try:
            project_service = self.get_hub_services_factory().createProjectService()
            return project_service.getProjectByName(project_name).get()
        except Exception as exception:
            raise Exception("Project not found "+exception.getMessage())

    def get_all_releases(self, project_view):
        return self.__connection_helper.createHubCompositeService().getAllReleases(project_view)

    def get_project_id_by_view(self, project_view):
        return self.__connection_helper.createHubCompositeService().getProjectIdByView(project_view)

    def get_project_version_id_by_view(self, version_view):
        return self.__connection_helper.createHubCompositeService().getProjectVersionIdByView(version_view)

    def get_project_url(self, project_view):
        return "{}/api/projects/{}".format(self.BASE_URL, self.get_project_id_by_view(project_view))

    def get_project_version_url_by_id(self, version_id, project_id):
        return "{}/api/projects/{}/versions/{}/components".format(self.BASE_URL,project_id, version_id)

    def get_health_status(self):
        return self.__connection_helper.createHubCompositeService().getHealthStatus()

    def get_hub_services_factory(self):
        hub_services_factory = self.__connection_helper.createBlackDuckServicesFactory()
        return hub_services_factory

    def get_risk_profile(self, project_name, version):
        try:
            hub_services_factory = self.get_hub_services_factory()
            project_service = hub_services_factory.createProjectService()
            project_view = project_service.getProjectByName(project_name).get()
            version_view = project_service.getProjectVersion(project_view, version).get()
            risk_profile_view = self.__connection_helper.createHubCompositeService().getRiskProfiles(version_view, project_view)
            return risk_profile_view, project_view, version_view
        except Exception as exception:
            raise RuntimeError("Unable to get the risk profile data, please check the Project and/or Version: %s" % exception.getMessage())

    def get_policy_status(self, project_name, version):
        try:
            hub_services_factory = self.get_hub_services_factory()
            project_service = hub_services_factory.createProjectService()
            project_view = project_service.getProjectByName(project_name).get()
            version_view = project_service.getProjectVersion(project_view, version).get()
            blackduck_api_client = hub_services_factory.getBlackDuckApiClient()
            version_bom_policy_status_view = blackduck_api_client.getResponse(version_view, ProjectVersionView.POLICY_STATUS_LINK_RESPONSE)
            no_policy_response  = 'No Policy enabled or configured'
            if not version_bom_policy_status_view.isPresent():
                return no_policy_response
            else:
                return version_bom_policy_status_view.get().overallStatus.prettyPrint()
        except Exception as exception:
            raise RuntimeError("Unable to get the policy status, please check the Project and/or Version: %s" % exception.getMessage())


    def get_project_service(self):
        return self.get_hub_services_factory().createProjectService()