/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner.command;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanCommandOutput;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.blackduck.service.model.ScannerSplitStream;
import com.synopsys.integration.blackduck.service.model.StreamRedirectThread;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.NameVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ScanCommandCallable
implements Callable<ScanCommandOutput> {
    private static final List<String> DRY_RUN_FILES_TO_KEEP = Arrays.asList("data");
    private final IntLogger logger;
    private final ScanPathsUtility scanPathsUtility;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final ScanCommand scanCommand;
    private final NameVersion projectAndVersion;
    private final String codeLocationName;
    private final boolean onlineScan;
    private final boolean cleanupOutput;

    public ScanCommandCallable(IntLogger logger, ScanPathsUtility scanPathsUtility, IntEnvironmentVariables intEnvironmentVariables, ScanCommand scanCommand, boolean cleanupOutput) {
        this.logger = logger;
        this.scanPathsUtility = scanPathsUtility;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.scanCommand = scanCommand;
        this.projectAndVersion = new NameVersion(scanCommand.getProjectName(), scanCommand.getVersionName());
        this.codeLocationName = scanCommand.getName();
        this.onlineScan = !scanCommand.isDryRun();
        this.cleanupOutput = cleanupOutput;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ScanCommandOutput call() {
        String commandToExecute = "command_not_yet_configured";
        try {
            ScanPaths scanPaths = this.scanPathsUtility.determineSignatureScannerPaths(this.scanCommand.getSignatureScannerInstallDirectory());
            List<String> cmd = this.scanCommand.createCommandForProcessBuilder(this.logger, scanPaths, this.scanCommand.getOutputDirectory().getAbsolutePath());
            cmd.add(this.scanCommand.getTargetPath());
            commandToExecute = this.createPrintableCommand(cmd);
            this.logger.info(String.format("Black Duck CLI command: %s", commandToExecute));
            File standardOutFile = this.scanPathsUtility.createStandardOutFile(this.scanCommand.getOutputDirectory());
            try (FileOutputStream outputFileStream = new FileOutputStream(standardOutFile);){
                ScannerSplitStream splitOutputStream = new ScannerSplitStream(this.logger, outputFileStream);
                ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                processBuilder.environment().putAll(this.intEnvironmentVariables.getVariables());
                if (this.onlineScan) {
                    this.prepareEnvironmentWithCredentials(processBuilder);
                }
                processBuilder.environment().put("BD_HUB_NO_PROMPT", "true");
                processBuilder.redirectErrorStream(true);
                Process blackDuckCliProcess = processBuilder.start();
                StreamRedirectThread redirectThread = new StreamRedirectThread(blackDuckCliProcess.getInputStream(), splitOutputStream);
                redirectThread.start();
                int returnCode = this.executeScanProcess(blackDuckCliProcess, redirectThread);
                splitOutputStream.flush();
                this.logger.info(IOUtils.toString((InputStream)blackDuckCliProcess.getInputStream(), (Charset)StandardCharsets.UTF_8));
                this.logger.info("Black Duck Signature Scanner return code: " + returnCode);
                this.logger.info("You can view the logs at: '" + this.scanCommand.getOutputDirectory().getCanonicalPath() + "'");
                if (returnCode != 0) {
                    ScanCommandOutput scanCommandOutput = ScanCommandOutput.FAILURE(this.projectAndVersion, this.codeLocationName, this.logger, this.scanCommand, commandToExecute, returnCode);
                    return scanCommandOutput;
                }
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("There was a problem scanning target '%s': %s", this.scanCommand.getTargetPath(), e.getMessage());
            return ScanCommandOutput.FAILURE(this.projectAndVersion, this.codeLocationName, this.logger, this.scanCommand, commandToExecute, errorMessage, e);
        }
        this.deleteFilesIfNeeded();
        return ScanCommandOutput.SUCCESS(this.projectAndVersion, this.codeLocationName, this.logger, this.scanCommand, commandToExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeScanProcess(Process blackDuckCliProcess, StreamRedirectThread redirectThread) throws InterruptedException {
        int returnCode = -1;
        try {
            returnCode = blackDuckCliProcess.waitFor();
            redirectThread.join();
        }
        finally {
            if (blackDuckCliProcess.isAlive()) {
                blackDuckCliProcess.destroy();
            }
            if (redirectThread.isAlive()) {
                redirectThread.interrupt();
            }
        }
        return returnCode;
    }

    private void prepareEnvironmentWithCredentials(ProcessBuilder processBuilder) {
        if (!StringUtils.isEmpty((CharSequence)this.scanCommand.getBlackDuckApiToken())) {
            processBuilder.environment().put("BD_HUB_TOKEN", this.scanCommand.getBlackDuckApiToken());
        } else {
            processBuilder.environment().put("BD_HUB_PASSWORD", this.scanCommand.getBlackDuckPassword());
        }
    }

    private void deleteFilesIfNeeded() {
        if (this.onlineScan && this.cleanupOutput) {
            FileUtils.deleteQuietly((File)this.scanCommand.getOutputDirectory());
        } else if (this.cleanupOutput) {
            File[] outputFiles;
            for (File outputFile : outputFiles = this.scanCommand.getOutputDirectory().listFiles()) {
                if (DRY_RUN_FILES_TO_KEEP.contains(outputFile.getName())) continue;
                FileUtils.deleteQuietly((File)outputFile);
            }
        }
    }

    private String createPrintableCommand(List<String> cmd) {
        ArrayList<String> cmdToOutput = new ArrayList<String>();
        cmdToOutput.addAll(cmd);
        int passwordIndex = cmdToOutput.indexOf("--password");
        if (passwordIndex > -1) {
            ++passwordIndex;
        }
        int proxyPasswordIndex = -1;
        for (int commandIndex = 0; commandIndex < cmdToOutput.size(); ++commandIndex) {
            String commandParameter = (String)cmdToOutput.get(commandIndex);
            if (!commandParameter.contains("-Dhttp.proxyPassword=")) continue;
            proxyPasswordIndex = commandIndex;
        }
        this.maskIndex(cmdToOutput, passwordIndex);
        this.maskIndex(cmdToOutput, proxyPasswordIndex);
        return StringUtils.join(cmdToOutput, (String)" ");
    }

    private void maskIndex(List<String> cmd, int indexToMask) {
        if (indexToMask > -1) {
            String cmdToMask = cmd.get(indexToMask);
            Object[] maskedArray = new String[cmdToMask.length()];
            Arrays.fill(maskedArray, "*");
            cmd.set(indexToMask, StringUtils.join((Object[])maskedArray));
        }
    }
}

