/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.keystore;

import com.synopsys.integration.log.IntLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class KeyStoreHelper {
    private static final char[] DEFAULT_JAVA_KEYSTORE_PASSWORD = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
    private final IntLogger logger;

    public KeyStoreHelper(IntLogger logger) {
        this.logger = logger;
    }

    public void updateKeyStoreWithServerCertificate(String alias, Certificate serverCertificate, String keyStoreFilePath) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream inputStream = new FileInputStream(keyStoreFilePath);){
                keyStore.load(inputStream, DEFAULT_JAVA_KEYSTORE_PASSWORD);
            }
            keyStore.setCertificateEntry(alias, serverCertificate);
            try (FileOutputStream outputStream = new FileOutputStream(keyStoreFilePath);){
                keyStore.store(outputStream, DEFAULT_JAVA_KEYSTORE_PASSWORD);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.logger.errorAndDebug("Could not manage the local keystore - communicating to the server will have to be configured manually: " + e.getMessage(), e);
        }
    }
}

