/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.developermode;

import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.wait.WaitJobTask;
import java.io.IOException;

public class DeveloperScanWaitJobTask
implements WaitJobTask {
    private HttpUrl resultUrl;
    private BlackDuckApiClient blackDuckApiClient;

    public DeveloperScanWaitJobTask(BlackDuckApiClient blackDuckApiClient, HttpUrl resultUrl) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.resultUrl = resultUrl;
    }

    @Override
    public boolean isComplete() throws IntegrationException {
        boolean bl;
        block10: {
            Response response = this.blackDuckApiClient.get(this.resultUrl);
            try {
                bl = response.isStatusCodeSuccess();
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IntegrationRestException ex) {
                    if (404 == ex.getHttpStatusCode()) {
                        return false;
                    }
                    throw ex;
                }
                catch (IOException ex) {
                    throw new BlackDuckIntegrationException(ex.getMessage(), ex);
                }
            }
            response.close();
        }
        return bl;
    }
}

