/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.util;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Expander;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CommonZipExpander {
    protected final IntLogger logger;
    private final Expander expander;

    public CommonZipExpander(IntLogger logger) {
        this(logger, new Expander());
    }

    public CommonZipExpander(IntLogger logger, Expander expander) {
        this.logger = logger;
        this.expander = expander;
    }

    public void expand(File sourceArchiveFile, File targetExpansionDirectory) throws IOException, ArchiveException, IntegrationException {
        this.expandUnknownFile(sourceArchiveFile, targetExpansionDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(InputStream sourceArchiveStream, File targetExpansionDirectory) throws IOException, ArchiveException, IntegrationException {
        File tempZipFile = File.createTempFile("tmpzip", null);
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempZipFile);){
                IOUtils.copy((InputStream)sourceArchiveStream, (OutputStream)fileOutputStream);
            }
            if (!tempZipFile.exists() || tempZipFile.length() <= 0L) {
                throw new IntegrationException(String.format("The zip file (%s) was not created correctly. Please try again.", tempZipFile.getAbsolutePath()));
            }
            this.expandUnknownFile(tempZipFile, targetExpansionDirectory);
        }
        finally {
            FileUtils.deleteQuietly((File)tempZipFile);
        }
    }

    private void expandUnknownFile(File unknownFile, File targetExpansionDirectory) throws IOException, IntegrationException, ArchiveException {
        block14: {
            String format;
            try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(unknownFile.toPath(), new OpenOption[0]));){
                format = ArchiveStreamFactory.detect((InputStream)i);
            }
            this.beforeExpansion(unknownFile, targetExpansionDirectory);
            try {
                if ("zip".equals(format)) {
                    try (ZipFile zipFile = new ZipFile(unknownFile);){
                        this.expander.expand(zipFile, targetExpansionDirectory);
                        break block14;
                    }
                }
                this.expander.expand(unknownFile, targetExpansionDirectory);
            }
            catch (IOException | ArchiveException e) {
                this.logger.error(String.format("Couldn't extract the archive file (%s) - validate the contents and permissions: " + e.getMessage(), unknownFile.getAbsolutePath()));
                throw e;
            }
        }
        this.afterExpansion(unknownFile, targetExpansionDirectory);
    }

    public void beforeExpansion(File sourceArchiveFile, File targetExpansionDirectory) throws IntegrationException {
    }

    public void afterExpansion(File sourceArchiveFile, File targetExpansionDirectory) throws IntegrationException {
    }
}

