/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.util.Stringable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class HttpUrl
extends Stringable {
    private String urlString;
    private URI uri;
    private URL url;

    public HttpUrl(String url) throws IntegrationException {
        this.populateUrl(url);
    }

    public HttpUrl(URL url) throws IntegrationException {
        this.populateUrl(url.toString());
    }

    public HttpUrl(URI uri) throws IntegrationException {
        this.populateUrl(uri.toString());
    }

    public HttpUrl appendRelativeUrl(String relativeUrl) throws IntegrationException {
        String baseUrl = this.urlString;
        try {
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            URL baseURL = new URL(baseUrl);
            if (relativeUrl.startsWith("/")) {
                relativeUrl = relativeUrl.substring(1);
            }
            return new HttpUrl(new URL(baseURL, relativeUrl).toString());
        }
        catch (MalformedURLException e) {
            throw new IntegrationException(String.format("Error appending the relative url (%s) to base url (%s): %s", relativeUrl, baseUrl, e.getMessage()), e);
        }
    }

    private void populateUrl(String url) throws IntegrationException {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IntegrationException("The url must not be blank.");
        }
        this.urlString = url;
        try {
            this.uri = new URI(url);
            this.url = this.uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new IntegrationException(String.format("The url (%s) is not valid: %s", url, e.getMessage()), e);
        }
    }

    public String string() {
        return this.urlString;
    }

    public URL url() {
        return this.url;
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public String toString() {
        return this.urlString;
    }
}

