/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.service;

import com.google.gson.JsonObject;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.client.IntHttpClient;
import com.synopsys.integration.rest.component.IntRestResponse;
import com.synopsys.integration.rest.request.PageRequestHandler;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.rest.service.IntJsonTransformer;
import java.io.IOException;
import java.util.ArrayList;

public class IntResponseTransformer {
    private final IntHttpClient intHttpClient;
    private final IntJsonTransformer intJsonTransformer;

    public IntResponseTransformer(IntHttpClient intHttpClient, IntJsonTransformer intJsonTransformer) {
        this.intHttpClient = intHttpClient;
        this.intJsonTransformer = intJsonTransformer;
    }

    public <R extends IntRestResponse> R getResponses(Request.Builder requestBuilder, PageRequestHandler pageRequestHandler, Class<R> responseClass, int pageSize) throws IntegrationException {
        R response;
        int totalResponseDataCount;
        ArrayList<R> allResponses = new ArrayList<R>();
        int currentResponseDataCount = 0;
        int offset = 0;
        do {
            Request request = pageRequestHandler.createPageRequest(requestBuilder, offset, pageSize);
            response = this.getResponse(request, responseClass);
            allResponses.add(response);
            totalResponseDataCount = pageRequestHandler.getTotalResponseCount(response);
            offset += pageSize;
        } while (totalResponseDataCount > (currentResponseDataCount += pageRequestHandler.getCurrentResponseCount(response)));
        return (R)pageRequestHandler.combineResponses(allResponses);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R extends IntRestResponse> R getResponse(Request request, Class<R> responseClass) throws IntegrationException {
        try (Response response = this.intHttpClient.execute(request);){
            this.intHttpClient.throwExceptionForError(response);
            Object r = this.intJsonTransformer.getResponse(response, responseClass);
            return r;
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public <R extends IntRestResponse> R getResponseAs(String json, Class<R> responseClass) throws IntegrationException {
        return (R)((IntRestResponse)this.intJsonTransformer.getComponentAs(json, responseClass));
    }

    public <R extends IntRestResponse> R getResponseAs(JsonObject jsonObject, Class<R> responseClass) throws IntegrationException {
        return (R)((IntRestResponse)this.intJsonTransformer.getComponentAs(jsonObject, responseClass));
    }
}

