#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import sys
from org.apache.http.client import ClientProtocolException

params = {'url': configuration.url, 'username': configuration.username, 'password': configuration.password,
          'authenticationMethod': configuration.authenticationMethod, 'proxyHost': configuration.proxyHost,
          'proxyPort': configuration.proxyPort, 'proxyUsername': configuration.proxyUsername,
          'proxyPassword': configuration.proxyPassword, 'proxyDomain': configuration.proxyDomain}

path = configuration.checkConfigurationPath
if hasattr(configuration, 'checkConfigurationContentType') and configuration.checkConfigurationContentType:
    contentType = configuration.checkConfigurationContentType
else:
    contentType = None

response = None
try:
    response = HttpRequest(params).head(path, contentType=contentType)
except ClientProtocolException:
    raise Exception("URL is not valid")

if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("HTTP response code %s (%s)" % (response.status, reason))
