#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import org.slf4j.LoggerFactory as LoggerFactory
import sys
import json

def findNewCommit(oldCommitMap, newCommitMap):
    branch = None
    commitId = None

    # loop over new map branches
    for newBranch, newCommitId in newCommitMap.iteritems():
        # check if branch exists in old map
        if newBranch in oldCommitMap:
            oldCommitId = oldCommitMap[newBranch]
            # compare commit ids
            if newCommitId != oldCommitId:
                branch = newBranch
                commitId = newCommitId
                break
        else:
            # new branch, this triggered it
            branch = newBranch
            commitId = newCommitId
            break

    return branch, commitId

logger = LoggerFactory.getLogger("bitbucketServer")
if server is None:
    print "No Bitbucket server provided."
    sys.exit(1)

request = HttpRequest(server, username, password)
context = "/rest/api/1.0/projects/%s/repos/%s" % (project, repository)
branches_path = "%s/%s?limit=1000" % (context, "branches")
response = request.get(branches_path, contentType="application/json")

if not response.isSuccessful():
    if response.status == 404 and triggerOnInitialPublish:
        print "Repository '%s:%s' not found in bitbucket. Ignoring." % (project, repository)

        if not triggerState:
            branch = commitId = triggerState = "unknown"
    else:
        print "Failed to fetch branch information from Bitbucket server %s" % server['url']
        response.errorDump()
    sys.exit(1)
else:
    info = json.loads(response.response)

    # build a map of the commit ids for each branch
    newCommit = {}
    for branch in info["values"]:
        if branch["displayId"] not in excludeBranches.strip(" ").strip(",").split(","):
            if (branchName is None) or (branch["displayId"] == branchName):
                logger.debug("branchName = %s" % branchName)
                branchid = branch["displayId"]
                lastcommit = branch["latestCommit"]
                newCommit[branchid] = lastcommit

    # trigger state is perisisted as json
    newTriggerState = json.dumps(newCommit)

    if triggerState != newTriggerState:
        if len(triggerState) == 0:
            oldCommit = {}
        else:
            oldCommit = json.loads(triggerState)

        branch, commitId = findNewCommit(oldCommit, newCommit)

        if branch and commitId:
            triggerState = newTriggerState
            print ("Bitbucket triggered release for %s-%s" % (branch, commitId))
