#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from bitbucketServer.BitbucketServer import BitbucketServerClient
import json
import org.slf4j.LoggerFactory as LoggerFactory

logger = LoggerFactory.getLogger("com.xebialabs.bitbucket-plugin")
if server == "" or project == "" or slug == "":
    commits = []
else:
    stash = BitbucketServerClient.get_client(server, username, password, token=None)
    data = json.loads(stash.bitbucketserver_querycommits(locals()))

    commits = data["values"]

authors = {}
committers = {}
people = []
for commit in commits:
    print "commit: %s" % commit
    if commit["author"]["name"] in authors.keys():
        authors[commit["author"]["name"]] += 1
    else:
        authors[commit["author"]["name"]] = 1
    if commit["author"]["name"] not in people:
        people.append(commit["author"]["name"])

    if commit["committer"]["name"] in committers.keys():
        committers[commit["committer"]["name"]] += 1
    else:
        committers[commit["committer"]["name"]] = 1
    if commit["committer"]["name"] not in people:
        people.append(commit["committer"]["name"])

data = {
    "commits": commits,
    "authors": [{"name":author,"value":authors[author]} for author in authors.keys()],
    "committers": [{"name":committer,"value":committers[committer]} for committer in committers.keys()],
    "people": people
}
