#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from bitbucketCloud.BitbucketCloud import BitbucketCloudClient
import json
import time
from java.time import LocalDate, ZonedDateTime
import org.slf4j.Logger as Logger
import org.slf4j.LoggerFactory as LoggerFactory

logger = LoggerFactory.getLogger("com.xebialabs.bitbucket-plugin")
def convertRFC3339ToDate(timestamp):
    zonedDateTime = ZonedDateTime.parse(timestamp)
    return zonedDateTime.toLocalDate()

bitbucket = BitbucketCloudClient.get_client(server, username, password, token=None)
commits = bitbucket.bitbucketcloud_querycommits(locals())

# Compile data for summary view
commitsByDay = {}
for commit in commits:
    logger.warn("commit date %s" % commit["date"])
    commitDate = convertRFC3339ToDate(commit["date"])
    if commitDate in commitsByDay.keys():
        commitsByDay[commitDate] += 1
    else:
        commitsByDay[commitDate] = 1

dates = [date for date in commitsByDay.keys()]
dates.sort()
startDate = dates[0]
endDate = dates[-1]
days = []
commitsEachDay = []
daysWithCommits = [dayCommits.toString() for dayCommits in commitsByDay.keys()]
while startDate.isBefore(endDate.plusDays(1)):
    days.append(startDate.toString())
    if startDate.toString() in daysWithCommits:
        commitsEachDay.append(commitsByDay[startDate])
    else:
        commitsEachDay.append(0)
    startDate = startDate.plusDays(1)

data = {
    "dates": days,
    "commitsEachDay": commitsEachDay,
    "commits": commits
}
