#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#


import sys
import json

def findNewCommit(oldCommitMap, newCommitMap):
    branch = ""
    commitId = ""

    # loop over new map branches
    for newBranch, newCommitId in newCommitMap.iteritems():
        # check if branch exists in old map
        if newBranch in oldCommitMap:
            oldCommitId = oldCommitMap[newBranch]
            # compare commit ids
            if newCommitId != oldCommitId:
                branch = newBranch
                commitId = newCommitId
                break
        else:
            # new branch, this triggered it
            branch = newBranch
            commitId = newCommitId
            break

    return branch, commitId

if server is None:
    print "No Bitbucket Cloud provided."
    sys.exit(1)

request = HttpRequest(server, username, password)
context = "/2.0/repositories/%s/refs" % (repo_full_name)
branches_path = "%s/%s?limit=1000" % (context, "branches")
response = request.get(branches_path, contentType = "application/json")

if not response.isSuccessful():
    if response.status == 404 and triggerOnInitialPublish:
        print "Repository '%s' not found in bitbucket cloud. Ignoring." % (repo_full_name)

        if not triggerState:
            branch = commitId = triggerState = "unknown"
    else:
        print "Failed to fetch branch information from Bitbucket cloud server %s" % server["url"]
        response.errorDump()
    sys.exit(1)
else:
    info = json.loads(response.response)

    # build a map of the commit ids for each branch
    newCommit = {}
    for branch in info["values"]:
        branchid = branch["name"]
        lastcommit = branch["target"]["hash"]
        newCommit[branchid] = lastcommit

    # trigger state is perisisted as json
    newTriggerState = json.dumps(newCommit)

    if triggerState != newTriggerState:
        if len(triggerState) == 0:
            oldCommit = {}
        else:
            oldCommit = json.loads(triggerState)

        branch, commitId = findNewCommit(oldCommit, newCommit)

        if branchName == "" or (branchName != "" and branchName == branch ):
            triggerState = newTriggerState

        print("Bitbucket triggered release for %s-%s" % (branch, commitId))
