#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from bitbucketCloud.BitbucketCloud import BitbucketCloudClient
import json

if server == "" or repo_full_name == "":
    values = []
    data = {"commits": values }
else:
    bitbucket = BitbucketCloudClient.get_client(server, username, password)
    data = bitbucket.bitbucketcloud_querycommits( locals() )
    commits = data

authors = {}
committers = {}
people = []
for commit in commits:
    print "commit: %s" % json.dumps(commit, indent=4, sort_keys=True)
    if commit["author"]["user"]["nickname"] in authors.keys():
        authors[commit["author"]["user"]["nickname"]] += 1
    else:
        authors[commit["author"]["user"]["nickname"]] = 1
    if commit["author"]["user"]["nickname"] not in people:
        people.append(commit["author"]["user"]["nickname"])

    if commit["author"]["user"]["nickname"] in committers.keys():
        committers[commit["author"]["user"]["nickname"]] += 1
    else:
        committers[commit["author"]["user"]["nickname"]] = 1
    if commit["author"]["user"]["nickname"] not in people:
        people.append(commit["author"]["user"]["nickname"])

data = {
    "commits": commits,
    "authors": [{"name":author,"value":authors[author]} for author in authors.keys()],
    "committers": [{"name":committer,"value":committers[committer]} for committer in committers.keys()],
    "people": people
}
