#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from bitbucketServer.BitbucketServer import BitbucketServerClient
import json
import time
from java.time import ZonedDateTime

def convertRFC3339ToDate(timestamp):
    zonedDateTime = ZonedDateTime.parse(timestamp)
    return zonedDateTime.toLocalDate()

stash = BitbucketServerClient.get_client(server, username, password)
data = json.loads(stash.bitbucketserver_querycommits(locals()))
commits = data["values"]

# Compile data for summary view
commitsByDay = {}
for commit in commits:
    stringDate = time.strftime("%Y-%m-%dT%H:%M:%S.00Z", time.localtime(commit["committerTimestamp"]/1000))
    commitDate = convertRFC3339ToDate(stringDate)
    if commitDate in commitsByDay.keys():
        commitsByDay[commitDate] += 1
    else:
        commitsByDay[commitDate] = 1

dates = [date for date in commitsByDay.keys()]
dates.sort()
startDate = dates[0]
endDate = dates[-1]
days = []
commitsEachDay = []
daysWithCommits = [dayCommits.toString() for dayCommits in commitsByDay.keys()]
while startDate.isBefore(endDate.plusDays(1)):
    days.append(startDate.toString())
    if startDate.toString() in daysWithCommits:
        commitsEachDay.append(commitsByDay[startDate])
    else:
        commitsEachDay.append(0)
    startDate = startDate.plusDays(1)

data = {"dates": days, "commitsEachDay": commitsEachDay, "commits": commits}
